/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockitoPostProcessor;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class MockitoTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String MOCKS_ATTRIBUTE_NAME = MockitoTestExecutionListener.class.getName() + ".mocks";

    @Override
    public final int getOrder() {
        return 1950;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.closeMocks(testContext);
        this.initMocks(testContext);
        this.injectFields(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (Boolean.TRUE.equals(testContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE))) {
            this.closeMocks(testContext);
            this.initMocks(testContext);
            this.reinjectFields(testContext);
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        this.closeMocks(testContext);
    }

    @Override
    public void afterTestClass(TestContext testContext) throws Exception {
        this.closeMocks(testContext);
    }

    private void initMocks(TestContext testContext) {
        if (this.hasMockitoAnnotations(testContext)) {
            testContext.setAttribute(MOCKS_ATTRIBUTE_NAME, MockitoAnnotations.openMocks((Object)testContext.getTestInstance()));
        }
    }

    private void closeMocks(TestContext testContext) throws Exception {
        Object mocks = testContext.getAttribute(MOCKS_ATTRIBUTE_NAME);
        if (mocks instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)mocks;
            closeable.close();
        }
    }

    private boolean hasMockitoAnnotations(TestContext testContext) {
        MockitoAnnotationCollection collector = new MockitoAnnotationCollection();
        ReflectionUtils.doWithFields(testContext.getTestClass(), collector);
        return collector.hasAnnotations();
    }

    private void injectFields(TestContext testContext) {
        this.postProcessFields(testContext, (mockitoField, postProcessor) -> postProcessor.inject(mockitoField.field, mockitoField.target, mockitoField.definition));
    }

    private void reinjectFields(TestContext testContext) {
        this.postProcessFields(testContext, (mockitoField, postProcessor) -> {
            ReflectionUtils.makeAccessible(mockitoField.field);
            ReflectionUtils.setField(mockitoField.field, testContext.getTestInstance(), null);
            postProcessor.inject(mockitoField.field, mockitoField.target, mockitoField.definition);
        });
    }

    private void postProcessFields(TestContext testContext, BiConsumer<MockitoField, MockitoPostProcessor> consumer) {
        DefinitionsParser parser = new DefinitionsParser();
        parser.parse(testContext.getTestClass());
        if (!parser.getDefinitions().isEmpty()) {
            MockitoPostProcessor postProcessor = testContext.getApplicationContext().getBean(MockitoPostProcessor.class);
            for (Definition definition : parser.getDefinitions()) {
                Field field = parser.getField(definition);
                if (field == null) continue;
                consumer.accept(new MockitoField(field, testContext.getTestInstance(), definition), postProcessor);
            }
        }
    }

    private static final class MockitoAnnotationCollection
    implements ReflectionUtils.FieldCallback {
        private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();

        private MockitoAnnotationCollection() {
        }

        @Override
        public void doWith(Field field) throws IllegalArgumentException {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().getName().startsWith("org.mockito")) continue;
                this.annotations.add(annotation);
            }
        }

        boolean hasAnnotations() {
            return !this.annotations.isEmpty();
        }
    }

    private static final class MockitoField {
        private final Field field;
        private final Object target;
        private final Definition definition;

        private MockitoField(Field field, Object instance, Definition definition) {
            this.field = field;
            this.target = instance;
            this.definition = definition;
        }
    }
}

