/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.runner;

import java.util.function.Supplier;
import org.springframework.boot.test.context.assertj.AssertableWebApplicationContext;
import org.springframework.boot.test.context.runner.AbstractApplicationContextRunner;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebApplicationContext;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import wiremock.jakarta.servlet.ServletContext;

public final class WebApplicationContextRunner
extends AbstractApplicationContextRunner<WebApplicationContextRunner, ConfigurableWebApplicationContext, AssertableWebApplicationContext> {
    public WebApplicationContextRunner() {
        this(WebApplicationContextRunner.withMockServletContext(AnnotationConfigServletWebApplicationContext::new));
    }

    public WebApplicationContextRunner(Supplier<ConfigurableWebApplicationContext> contextFactory) {
        super(contextFactory, WebApplicationContextRunner::new);
    }

    private WebApplicationContextRunner(AbstractApplicationContextRunner.RunnerConfiguration<ConfigurableWebApplicationContext> configuration) {
        super(configuration, WebApplicationContextRunner::new);
    }

    public static Supplier<ConfigurableWebApplicationContext> withMockServletContext(Supplier<ConfigurableWebApplicationContext> contextFactory) {
        return contextFactory != null ? () -> {
            ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)contextFactory.get();
            context.setServletContext((ServletContext)new MockServletContext());
            return context;
        } : null;
    }
}

