/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.springframework.boot.logging.log4j2.Log4J2LoggingSystem;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.util.StringUtils;
import wiremock.org.apache.logging.log4j.Logger;
import wiremock.org.apache.logging.log4j.core.LoggerContext;
import wiremock.org.apache.logging.log4j.core.config.Configuration;
import wiremock.org.apache.logging.log4j.core.config.arbiters.Arbiter;
import wiremock.org.apache.logging.log4j.core.config.plugins.Plugin;
import wiremock.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import wiremock.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import wiremock.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import wiremock.org.apache.logging.log4j.core.config.plugins.PluginLoggerContext;
import wiremock.org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="SpringProfile", category="Core", elementType="Arbiter", deferChildren=true, printObject=true)
final class SpringProfileArbiter
implements Arbiter {
    private final Environment environment;
    private final Profiles profiles;

    private SpringProfileArbiter(Environment environment2, String[] profiles) {
        this.environment = environment2;
        this.profiles = Profiles.of(profiles);
    }

    public boolean isCondition() {
        return this.environment != null && this.environment.acceptsProfiles(this.profiles);
    }

    @PluginBuilderFactory
    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder
    implements wiremock.org.apache.logging.log4j.core.util.Builder<SpringProfileArbiter> {
        private static final Logger statusLogger = StatusLogger.getLogger();
        @PluginBuilderAttribute
        private String name;
        @PluginConfiguration
        private Configuration configuration;
        @PluginLoggerContext
        private LoggerContext loggerContext;

        private Builder() {
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        public SpringProfileArbiter build() {
            Environment environment2 = Log4J2LoggingSystem.getEnvironment(this.loggerContext);
            if (environment2 == null) {
                statusLogger.debug("Creating Arbiter without a Spring Environment");
            }
            String name = this.configuration.getStrSubstitutor().replace(this.name);
            String[] profiles = StringUtils.trimArrayElements(StringUtils.commaDelimitedListToStringArray(name));
            return new SpringProfileArbiter(environment2, profiles);
        }
    }
}

