/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.convert.ArrayToDelimitedStringConverter;
import org.springframework.boot.convert.CharArrayFormatter;
import org.springframework.boot.convert.CharSequenceToObjectConverter;
import org.springframework.boot.convert.CollectionToDelimitedStringConverter;
import org.springframework.boot.convert.DelimitedStringToArrayConverter;
import org.springframework.boot.convert.DelimitedStringToCollectionConverter;
import org.springframework.boot.convert.DurationToNumberConverter;
import org.springframework.boot.convert.DurationToStringConverter;
import org.springframework.boot.convert.InetAddressFormatter;
import org.springframework.boot.convert.InputStreamSourceToByteArrayConverter;
import org.springframework.boot.convert.IsoOffsetFormatter;
import org.springframework.boot.convert.LenientBooleanToEnumConverterFactory;
import org.springframework.boot.convert.LenientStringToEnumConverterFactory;
import org.springframework.boot.convert.NumberToDataSizeConverter;
import org.springframework.boot.convert.NumberToDurationConverter;
import org.springframework.boot.convert.NumberToPeriodConverter;
import org.springframework.boot.convert.PeriodToStringConverter;
import org.springframework.boot.convert.StringToDataSizeConverter;
import org.springframework.boot.convert.StringToDurationConverter;
import org.springframework.boot.convert.StringToFileConverter;
import org.springframework.boot.convert.StringToPeriodConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.StringValueResolver;

public class ApplicationConversionService
extends FormattingConversionService {
    private static volatile ApplicationConversionService sharedInstance;
    private final boolean unmodifiable;

    public ApplicationConversionService() {
        this(null);
    }

    public ApplicationConversionService(StringValueResolver embeddedValueResolver) {
        this(embeddedValueResolver, false);
    }

    private ApplicationConversionService(StringValueResolver embeddedValueResolver, boolean unmodifiable) {
        if (embeddedValueResolver != null) {
            this.setEmbeddedValueResolver(embeddedValueResolver);
        }
        ApplicationConversionService.configure(this);
        this.unmodifiable = unmodifiable;
    }

    @Override
    public void addPrinter(Printer<?> printer) {
        this.assertModifiable();
        super.addPrinter(printer);
    }

    @Override
    public void addParser(Parser<?> parser) {
        this.assertModifiable();
        super.addParser(parser);
    }

    @Override
    public void addFormatter(Formatter<?> formatter) {
        this.assertModifiable();
        super.addFormatter(formatter);
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Formatter<?> formatter) {
        this.assertModifiable();
        super.addFormatterForFieldType(fieldType, formatter);
    }

    @Override
    public void addConverter(Converter<?, ?> converter) {
        this.assertModifiable();
        super.addConverter(converter);
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Printer<?> printer, Parser<?> parser) {
        this.assertModifiable();
        super.addFormatterForFieldType(fieldType, printer, parser);
    }

    @Override
    public void addFormatterForFieldAnnotation(AnnotationFormatterFactory<? extends Annotation> annotationFormatterFactory) {
        this.assertModifiable();
        super.addFormatterForFieldAnnotation(annotationFormatterFactory);
    }

    @Override
    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Converter<? super S, ? extends T> converter) {
        this.assertModifiable();
        super.addConverter(sourceType, targetType, converter);
    }

    @Override
    public void addConverter(GenericConverter converter) {
        this.assertModifiable();
        super.addConverter(converter);
    }

    @Override
    public void addConverterFactory(ConverterFactory<?, ?> factory) {
        this.assertModifiable();
        super.addConverterFactory(factory);
    }

    @Override
    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.assertModifiable();
        super.removeConvertible(sourceType, targetType);
    }

    private void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("This ApplicationConversionService cannot be modified");
        }
    }

    public boolean isConvertViaObjectSourceType(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Set<GenericConverter.ConvertiblePair> pairs;
        GenericConverter converter = this.getConverter(sourceType, targetType);
        Set<GenericConverter.ConvertiblePair> set = pairs = converter != null ? converter.getConvertibleTypes() : null;
        if (pairs != null) {
            for (GenericConverter.ConvertiblePair pair : pairs) {
                if (!Object.class.equals(pair.getSourceType())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConversionService getSharedInstance() {
        ApplicationConversionService sharedInstance = ApplicationConversionService.sharedInstance;
        if (sharedInstance != null) return sharedInstance;
        Class<ApplicationConversionService> clazz = ApplicationConversionService.class;
        synchronized (ApplicationConversionService.class) {
            sharedInstance = ApplicationConversionService.sharedInstance;
            if (sharedInstance != null) return sharedInstance;
            ApplicationConversionService.sharedInstance = sharedInstance = new ApplicationConversionService(null, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedInstance;
        }
    }

    public static void configure(FormatterRegistry registry) {
        DefaultConversionService.addDefaultConverters(registry);
        DefaultFormattingConversionService.addDefaultFormatters(registry);
        ApplicationConversionService.addApplicationFormatters(registry);
        ApplicationConversionService.addApplicationConverters(registry);
    }

    public static void addApplicationConverters(ConverterRegistry registry) {
        ApplicationConversionService.addDelimitedStringConverters(registry);
        registry.addConverter(new StringToDurationConverter());
        registry.addConverter(new DurationToStringConverter());
        registry.addConverter(new NumberToDurationConverter());
        registry.addConverter(new DurationToNumberConverter());
        registry.addConverter(new StringToPeriodConverter());
        registry.addConverter(new PeriodToStringConverter());
        registry.addConverter(new NumberToPeriodConverter());
        registry.addConverter(new StringToDataSizeConverter());
        registry.addConverter(new NumberToDataSizeConverter());
        registry.addConverter(new StringToFileConverter());
        registry.addConverter(new InputStreamSourceToByteArrayConverter());
        registry.addConverterFactory(new LenientStringToEnumConverterFactory());
        registry.addConverterFactory(new LenientBooleanToEnumConverterFactory());
        if (registry instanceof ConversionService) {
            ConversionService conversionService = (ConversionService)((Object)registry);
            ApplicationConversionService.addApplicationConverters(registry, conversionService);
        }
    }

    private static void addApplicationConverters(ConverterRegistry registry, ConversionService conversionService) {
        registry.addConverter(new CharSequenceToObjectConverter(conversionService));
    }

    public static void addDelimitedStringConverters(ConverterRegistry registry) {
        ConversionService service = (ConversionService)((Object)registry);
        registry.addConverter(new ArrayToDelimitedStringConverter(service));
        registry.addConverter(new CollectionToDelimitedStringConverter(service));
        registry.addConverter(new DelimitedStringToArrayConverter(service));
        registry.addConverter(new DelimitedStringToCollectionConverter(service));
    }

    public static void addApplicationFormatters(FormatterRegistry registry) {
        registry.addFormatter(new CharArrayFormatter());
        registry.addFormatter(new InetAddressFormatter());
        registry.addFormatter(new IsoOffsetFormatter());
    }

    public static void addBeans(FormatterRegistry registry, ListableBeanFactory beanFactory) {
        LinkedHashSet<Object> beans2 = new LinkedHashSet<Object>();
        beans2.addAll(beanFactory.getBeansOfType(GenericConverter.class).values());
        beans2.addAll(beanFactory.getBeansOfType(Converter.class).values());
        beans2.addAll(beanFactory.getBeansOfType(Printer.class).values());
        beans2.addAll(beanFactory.getBeansOfType(Parser.class).values());
        for (Object e : beans2) {
            if (e instanceof GenericConverter) {
                GenericConverter genericConverter = (GenericConverter)e;
                registry.addConverter(genericConverter);
                continue;
            }
            if (e instanceof Converter) {
                Converter converter = (Converter)e;
                registry.addConverter(converter);
                continue;
            }
            if (e instanceof Formatter) {
                Formatter formatter = (Formatter)e;
                registry.addFormatter(formatter);
                continue;
            }
            if (e instanceof Printer) {
                Printer printer = (Printer)e;
                registry.addPrinter(printer);
                continue;
            }
            if (!(e instanceof Parser)) continue;
            Parser parser = (Parser)e;
            registry.addParser(parser);
        }
    }
}

