/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.DefaultBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.ConfigDataEnvironment;
import org.springframework.boot.context.config.ConfigDataEnvironmentUpdateListener;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import wiremock.org.apache.commons.logging.Log;

public class ConfigDataEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int ORDER = -2147483638;
    public static final String ON_LOCATION_NOT_FOUND_PROPERTY = "spring.config.on-not-found";
    private final DeferredLogFactory logFactory;
    private final Log logger;
    private final ConfigurableBootstrapContext bootstrapContext;
    private final ConfigDataEnvironmentUpdateListener environmentUpdateListener;

    public ConfigDataEnvironmentPostProcessor(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext) {
        this(logFactory, bootstrapContext, null);
    }

    private ConfigDataEnvironmentPostProcessor(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigDataEnvironmentUpdateListener environmentUpdateListener) {
        this.logFactory = logFactory;
        this.logger = logFactory.getLog(this.getClass());
        this.bootstrapContext = bootstrapContext;
        this.environmentUpdateListener = environmentUpdateListener;
    }

    @Override
    public int getOrder() {
        return -2147483638;
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        this.postProcessEnvironment(environment2, application.getResourceLoader(), application.getAdditionalProfiles());
    }

    void postProcessEnvironment(ConfigurableEnvironment environment2, ResourceLoader resourceLoader, Collection<String> additionalProfiles) {
        this.logger.trace("Post-processing environment to add config data");
        resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
        this.getConfigDataEnvironment(environment2, resourceLoader, additionalProfiles).processAndApply();
    }

    ConfigDataEnvironment getConfigDataEnvironment(ConfigurableEnvironment environment2, ResourceLoader resourceLoader, Collection<String> additionalProfiles) {
        return new ConfigDataEnvironment(this.logFactory, this.bootstrapContext, environment2, resourceLoader, additionalProfiles, this.environmentUpdateListener);
    }

    public static void applyTo(ConfigurableEnvironment environment2) {
        ConfigDataEnvironmentPostProcessor.applyTo(environment2, null, null, Collections.emptyList());
    }

    public static void applyTo(ConfigurableEnvironment environment2, ResourceLoader resourceLoader, ConfigurableBootstrapContext bootstrapContext, String ... additionalProfiles) {
        ConfigDataEnvironmentPostProcessor.applyTo(environment2, resourceLoader, bootstrapContext, Arrays.asList(additionalProfiles));
    }

    public static void applyTo(ConfigurableEnvironment environment2, ResourceLoader resourceLoader, ConfigurableBootstrapContext bootstrapContext, Collection<String> additionalProfiles) {
        DeferredLogFactory logFactory = Supplier::get;
        bootstrapContext = bootstrapContext != null ? bootstrapContext : new DefaultBootstrapContext();
        ConfigDataEnvironmentPostProcessor postProcessor = new ConfigDataEnvironmentPostProcessor(logFactory, bootstrapContext);
        postProcessor.postProcessEnvironment(environment2, resourceLoader, additionalProfiles);
    }

    public static void applyTo(ConfigurableEnvironment environment2, ResourceLoader resourceLoader, ConfigurableBootstrapContext bootstrapContext, Collection<String> additionalProfiles, ConfigDataEnvironmentUpdateListener environmentUpdateListener) {
        DeferredLogFactory logFactory = Supplier::get;
        bootstrapContext = bootstrapContext != null ? bootstrapContext : new DefaultBootstrapContext();
        ConfigDataEnvironmentPostProcessor postProcessor = new ConfigDataEnvironmentPostProcessor(logFactory, bootstrapContext, environmentUpdateListener);
        postProcessor.postProcessEnvironment(environment2, resourceLoader, additionalProfiles);
    }
}

