/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class NearMiss
implements Comparable<NearMiss> {
    private final LoggedRequest request;
    private final StubMapping mapping;
    private final RequestPattern requestPattern;
    private final MatchResult matchResult;
    private final String scenarioState;

    @JsonCreator
    public NearMiss(@JsonProperty(value="request") LoggedRequest request2, @JsonProperty(value="stubMapping") StubMapping mapping, @JsonProperty(value="requestPattern") RequestPattern requestPattern, @JsonProperty(value="matchResult") MatchResult matchResult, @JsonProperty(value="scenarioState") String scenarioState) {
        this.request = request2;
        this.mapping = mapping;
        this.requestPattern = requestPattern;
        this.matchResult = matchResult;
        this.scenarioState = scenarioState;
    }

    public NearMiss(LoggedRequest request2, StubMapping mapping, MatchResult matchResult, String scenarioState) {
        this(request2, mapping, null, matchResult, scenarioState);
    }

    public NearMiss(LoggedRequest request2, RequestPattern requestPattern, MatchResult matchResult) {
        this(request2, null, requestPattern, matchResult, null);
    }

    public LoggedRequest getRequest() {
        return this.request;
    }

    public StubMapping getStubMapping() {
        return this.mapping;
    }

    public RequestPattern getRequestPattern() {
        return this.requestPattern;
    }

    public MatchResult getMatchResult() {
        return this.matchResult;
    }

    @Override
    public int compareTo(NearMiss o) {
        return o.getMatchResult().compareTo(this.matchResult);
    }

    @JsonIgnore
    public Diff getDiff() {
        if (this.requestPattern != null) {
            return new Diff(this.requestPattern, (Request)this.request);
        }
        return new Diff(this.getStubMapping(), this.request, this.scenarioState);
    }

    public String toString() {
        return this.getDiff().toString();
    }
}

