/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.recording.CaptureHeadersSpec;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import java.util.Map;
import java.util.function.Function;

public class RequestPatternTransformer
implements Function<Request, RequestPatternBuilder> {
    private final Map<String, CaptureHeadersSpec> headers;
    private final RequestBodyPatternFactory bodyPatternFactory;

    public RequestPatternTransformer(Map<String, CaptureHeadersSpec> headers, RequestBodyPatternFactory bodyPatternFactory) {
        this.headers = headers;
        this.bodyPatternFactory = bodyPatternFactory;
    }

    @Override
    public RequestPatternBuilder apply(Request request2) {
        RequestPatternBuilder builder = new RequestPatternBuilder(request2.getMethod(), WireMock.urlEqualTo(request2.getUrl()));
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry<String, CaptureHeadersSpec> header : this.headers.entrySet()) {
                String headerName = header.getKey();
                if (!request2.containsHeader(headerName)) continue;
                CaptureHeadersSpec spec = header.getValue();
                EqualToPattern headerMatcher = new EqualToPattern(request2.getHeader(headerName), spec.getCaseInsensitive());
                builder.withHeader(headerName, headerMatcher);
            }
        }
        byte[] body2 = request2.getBody();
        if (this.bodyPatternFactory != null && body2 != null && body2.length > 0) {
            builder.withRequestBody(this.bodyPatternFactory.forRequest(request2));
        }
        return builder;
    }
}

