/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Lazy;
import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.WeightedMatchResult;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class WeightedAggregateMatchResult
extends MatchResult {
    private final List<WeightedMatchResult> matchResults;
    private final Lazy<Pair<Boolean, List<SubEvent>>> resultAndEvents;

    public WeightedAggregateMatchResult(List<WeightedMatchResult> matchResults) {
        this.matchResults = matchResults;
        this.resultAndEvents = Lazy.lazy(() -> {
            ArrayList subEvents = new ArrayList(matchResults.size());
            return Pair.pair(matchResults.stream().allMatch(weightedMatchResult -> {
                boolean exactMatch = weightedMatchResult.isExactMatch();
                subEvents.addAll(weightedMatchResult.getMatchResult().getSubEvents());
                return exactMatch;
            }), subEvents);
        });
    }

    @Override
    public boolean isExactMatch() {
        return (Boolean)this.resultAndEvents.get().a;
    }

    @Override
    public double getDistance() {
        double totalDistance = 0.0;
        double sizeWithWeighting = 0.0;
        for (WeightedMatchResult matchResult : this.matchResults) {
            totalDistance += matchResult.getDistance();
            sizeWithWeighting += matchResult.getWeighting();
        }
        return totalDistance / sizeWithWeighting;
    }

    @Override
    public List<SubEvent> getSubEvents() {
        return (List)this.resultAndEvents.get().b;
    }

    @Override
    public List<MatchResult.DiffDescription> getDiffDescriptions() {
        return this.matchResults.stream().map(matchResult -> matchResult.getMatchResult().getDiffDescriptions()).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

