/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.JvmProxyConfigurer;
import com.github.tomakehurst.wiremock.junit.DslWrapper;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class WireMockExtension
extends DslWrapper
implements ParameterResolver,
BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    private final boolean configureStaticDsl;
    private final boolean failOnUnmatchedRequests;
    private final boolean isDeclarative;
    private Options options;
    private WireMockServer wireMockServer;
    private WireMockRuntimeInfo runtimeInfo;
    private boolean isNonStatic = false;
    private Boolean proxyMode;

    WireMockExtension() {
        this.configureStaticDsl = true;
        this.failOnUnmatchedRequests = false;
        this.isDeclarative = true;
    }

    protected WireMockExtension(Builder builder) {
        this.options = builder.options;
        this.configureStaticDsl = builder.configureStaticDsl;
        this.failOnUnmatchedRequests = builder.failOnUnmatchedRequests;
        this.proxyMode = builder.proxyMode;
        this.isDeclarative = false;
    }

    private WireMockExtension(Options options2, boolean configureStaticDsl, boolean failOnUnmatchedRequests, boolean proxyMode) {
        this.options = options2;
        this.configureStaticDsl = configureStaticDsl;
        this.failOnUnmatchedRequests = failOnUnmatchedRequests;
        this.proxyMode = proxyMode;
        this.isDeclarative = false;
    }

    public static Builder extensionOptions() {
        return WireMockExtension.newInstance();
    }

    public static Builder newInstance() {
        return new Builder();
    }

    protected void onBeforeAll(WireMockRuntimeInfo wireMockRuntimeInfo) {
    }

    protected void onBeforeAll(ExtensionContext extensionContext, WireMockRuntimeInfo wireMockRuntimeInfo) {
        this.onBeforeAll(wireMockRuntimeInfo);
    }

    protected void onBeforeEach(WireMockRuntimeInfo wireMockRuntimeInfo) {
    }

    protected void onBeforeEach(ExtensionContext extensionContext, WireMockRuntimeInfo wireMockRuntimeInfo) {
        this.onBeforeEach(wireMockRuntimeInfo);
    }

    protected void onAfterEach(WireMockRuntimeInfo wireMockRuntimeInfo) {
    }

    protected void onAfterEach(ExtensionContext extensionContext, WireMockRuntimeInfo wireMockRuntimeInfo) {
        this.onAfterEach(wireMockRuntimeInfo);
    }

    protected void onAfterAll(WireMockRuntimeInfo wireMockRuntimeInfo) {
    }

    protected void onAfterAll(ExtensionContext extensionContext, WireMockRuntimeInfo wireMockRuntimeInfo) {
        this.onAfterAll(wireMockRuntimeInfo);
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.parameterIsWireMockRuntimeInfo(parameterContext);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.parameterIsWireMockRuntimeInfo(parameterContext)) {
            return this.runtimeInfo;
        }
        return null;
    }

    private void startServerIfRequired(ExtensionContext extensionContext) {
        if (this.wireMockServer == null || !this.wireMockServer.isRunning()) {
            this.wireMockServer = new WireMockServer(this.resolveOptions(extensionContext));
            this.wireMockServer.start();
            this.runtimeInfo = new WireMockRuntimeInfo(this.wireMockServer);
            this.admin = this.wireMockServer;
            this.stubbing = this.wireMockServer;
            if (this.configureStaticDsl) {
                WireMock.configureFor(new WireMock(this));
            }
        }
    }

    private void setAdditionalOptions(ExtensionContext extensionContext) {
        if (this.proxyMode == null) {
            this.proxyMode = extensionContext.getElement().flatMap(annotatedElement -> AnnotationSupport.findAnnotation(annotatedElement, WireMockTest.class)).map(WireMockTest::proxyMode).orElse(false);
        }
    }

    private Options resolveOptions(ExtensionContext extensionContext) {
        WireMockConfiguration defaultOptions = WireMockConfiguration.options().dynamicPort();
        return extensionContext.getElement().flatMap(annotatedElement -> this.isDeclarative ? AnnotationSupport.findAnnotation(annotatedElement, WireMockTest.class) : Optional.empty()).map(this::buildOptionsFromWireMockTestAnnotation).orElseGet(() -> Optional.ofNullable(this.options).orElse(defaultOptions));
    }

    private Options buildOptionsFromWireMockTestAnnotation(WireMockTest annotation) {
        WireMockConfiguration options2 = WireMockConfiguration.options().port(annotation.httpPort()).extensionScanningEnabled(annotation.extensionScanningEnabled()).enableBrowserProxying(annotation.proxyMode());
        if (annotation.httpsEnabled()) {
            options2.httpsPort(annotation.httpsPort());
        }
        return options2;
    }

    private void stopServerIfRunning() {
        if (this.wireMockServer.isRunning()) {
            this.wireMockServer.stop();
        }
    }

    private boolean parameterIsWireMockRuntimeInfo(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().equals(WireMockRuntimeInfo.class) && this.isDeclarative;
    }

    @Override
    public final void beforeAll(ExtensionContext context) throws Exception {
        this.startServerIfRequired(context);
        this.setAdditionalOptions(context);
        this.onBeforeAll(context, this.runtimeInfo);
    }

    @Override
    public final void beforeEach(ExtensionContext context) throws Exception {
        if (this.wireMockServer == null) {
            this.isNonStatic = true;
            this.startServerIfRequired(context);
        } else {
            this.resetToDefaultMappings();
        }
        this.setAdditionalOptions(context);
        if (this.proxyMode.booleanValue()) {
            JvmProxyConfigurer.configureFor(this.wireMockServer);
        }
        this.onBeforeEach(context, this.runtimeInfo);
    }

    @Override
    public final void afterAll(ExtensionContext context) throws Exception {
        this.stopServerIfRunning();
        this.onAfterAll(context, this.runtimeInfo);
    }

    @Override
    public final void afterEach(ExtensionContext context) throws Exception {
        if (this.failOnUnmatchedRequests) {
            this.wireMockServer.checkForUnmatchedRequests();
        }
        if (this.isNonStatic) {
            this.stopServerIfRunning();
        }
        if (this.proxyMode.booleanValue()) {
            JvmProxyConfigurer.restorePrevious();
        }
        this.onAfterEach(context, this.runtimeInfo);
    }

    public WireMockRuntimeInfo getRuntimeInfo() {
        return new WireMockRuntimeInfo(this.wireMockServer);
    }

    public String baseUrl() {
        return this.wireMockServer.baseUrl();
    }

    public String url(String path) {
        return this.wireMockServer.url(path);
    }

    public int getHttpsPort() {
        return this.wireMockServer.httpsPort();
    }

    public int getPort() {
        return this.wireMockServer.port();
    }

    public static class Builder {
        private Options options = WireMockConfiguration.wireMockConfig().dynamicPort();
        private boolean configureStaticDsl = false;
        private boolean failOnUnmatchedRequests = false;
        private boolean proxyMode = false;

        public Builder options(Options options2) {
            this.options = options2;
            return this;
        }

        public Builder configureStaticDsl(boolean configureStaticDsl) {
            this.configureStaticDsl = configureStaticDsl;
            return this;
        }

        public Builder failOnUnmatchedRequests(boolean failOnUnmatched) {
            this.failOnUnmatchedRequests = failOnUnmatched;
            return this;
        }

        public Builder proxyMode(boolean proxyMode) {
            this.proxyMode = proxyMode;
            return this;
        }

        public WireMockExtension build() {
            if (this.proxyMode && !this.options.browserProxySettings().enabled() && this.options instanceof WireMockConfiguration) {
                ((WireMockConfiguration)this.options).enableBrowserProxying(true);
            }
            return new WireMockExtension(this.options, this.configureStaticDsl, this.failOnUnmatchedRequests, this.proxyMode);
        }
    }
}

