/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class ContentTypeHeader
extends HttpHeader {
    public static final String KEY = "Content-Type";
    private String[] parts;

    public ContentTypeHeader(String stringValue) {
        super(KEY, stringValue);
        this.parts = stringValue != null ? stringValue.split(";") : new String[]{};
    }

    private ContentTypeHeader() {
        super(KEY, new String[0]);
    }

    public static ContentTypeHeader absent() {
        return new ContentTypeHeader();
    }

    public ContentTypeHeader or(String stringValue) {
        return this.isPresent() ? this : new ContentTypeHeader(stringValue);
    }

    public String mimeTypePart() {
        return this.parts != null && this.parts.length > 0 ? this.parts[0] : null;
    }

    public Optional<String> encodingPart() {
        for (int i2 = 1; i2 < this.parts.length; ++i2) {
            if (!this.parts[i2].matches("\\s*charset\\s*=.*")) continue;
            return Optional.of(this.parts[i2].split("=")[1].replace("\"", ""));
        }
        return Optional.empty();
    }

    public Charset charset() {
        if (this.isPresent() && this.encodingPart().isPresent()) {
            return Charset.forName(this.encodingPart().get());
        }
        return StandardCharsets.UTF_8;
    }
}

