/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.AbstractFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import java.io.File;
import wiremock.jakarta.servlet.ServletContext;

public class ServletContextFileSource
extends AbstractFileSource {
    private final String rootPath;
    private final ServletContext servletContext;

    public ServletContextFileSource(ServletContext servletContext, String rootPath) {
        super(ServletContextFileSource.getRootFile(servletContext, rootPath));
        this.rootPath = rootPath;
        this.servletContext = servletContext;
    }

    private static File getRootFile(ServletContext servletContext, String rootPath) {
        String containerRootPath = servletContext.getRealPath(rootPath);
        servletContext.log("rootPath: " + rootPath);
        return new File(containerRootPath);
    }

    @Override
    public FileSource child(String subDirectoryName) {
        return new ServletContextFileSource(this.servletContext, this.rootPath + "/" + subDirectoryName);
    }

    @Override
    protected boolean readOnly() {
        return true;
    }
}

