/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.host.WebHost;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.publish.EndpointPublisherHelper;
import org.jboss.as.webservices.service.EndpointDeployService;
import org.jboss.as.webservices.service.EndpointService;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;

public final class EndpointPublishService
implements Service {
    private final ServiceName name;
    private volatile Context wsctx;
    private final DeploymentUnit deploymentUnit;
    private final Consumer<Context> wsctxConsumer;
    private final Supplier<WebHost> hostSupplier;

    private EndpointPublishService(ServiceName name, DeploymentUnit deploymentUnit, Consumer<Context> wsctxConsumer, Supplier<WebHost> hostSupplier) {
        this.name = name;
        this.deploymentUnit = deploymentUnit;
        this.wsctxConsumer = wsctxConsumer;
        this.hostSupplier = hostSupplier;
    }

    public void start(StartContext ctx) throws StartException {
        WSLogger.ROOT_LOGGER.starting(this.name);
        try {
            this.wsctx = EndpointPublisherHelper.doPublishStep(this.hostSupplier.get(), ctx.getChildTarget(), this.deploymentUnit);
            this.wsctxConsumer.accept(this.wsctx);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext ctx) {
        WSLogger.ROOT_LOGGER.stopping(this.name);
        this.wsctxConsumer.accept(null);
        List eps = this.wsctx.getEndpoints();
        if (eps == null || eps.isEmpty()) {
            return;
        }
        try {
            EndpointPublisherHelper.undoPublishStep(this.hostSupplier.get(), this.wsctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static ServiceBuilder createServiceBuilder(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd) {
        return EndpointPublishService.createServiceBuilder(serviceTarget, context, loader, hostName, urlPatternToClassName, jbwmd, wsmd, jbwsmd, null, null);
    }

    public static ServiceBuilder createServiceBuilder(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd, Map<Class<?>, Object> deploymentAttachments, CapabilityServiceSupport capabilityServiceSupport) {
        DeploymentUnit unit = EndpointDeployService.install(serviceTarget, context, loader, hostName, urlPatternToClassName, jbwmd, wsmd, jbwsmd, deploymentAttachments, capabilityServiceSupport);
        ServiceName serviceName = WSServices.ENDPOINT_PUBLISH_SERVICE.append(new String[]{context});
        ServiceBuilder builder = serviceTarget.addService(serviceName);
        builder.requires(WSServices.CONFIG_SERVICE);
        for (ServiceName epServiceName : EndpointService.getServiceNamesFromDeploymentUnit(unit)) {
            builder.requires(epServiceName);
        }
        Consumer contextConsumer = builder.provides(new ServiceName[]{serviceName});
        Supplier hostSupplier = builder.requires(WebHost.SERVICE_NAME.append(new String[]{hostName}));
        builder.setInstance((Service)new EndpointPublishService(serviceName, unit, contextConsumer, hostSupplier));
        return builder;
    }

    public static void install(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName) {
        EndpointPublishService.install(serviceTarget, context, loader, hostName, urlPatternToClassName, null, null, null);
    }

    public static void install(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd) {
        ServiceBuilder builder = EndpointPublishService.createServiceBuilder(serviceTarget, context, loader, hostName, urlPatternToClassName, jbwmd, wsmd, jbwsmd);
        builder.install();
    }
}

