/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.wsf.spi.deployment.WSFServlet;

public class AllowWSRequestPredicate
implements Predicate,
UnaryOperator<Set<String>> {
    private final AtomicReference<Set<String>> paths = new AtomicReference();
    private final Supplier<Set<String>> factory;

    public AllowWSRequestPredicate(final JBossWebMetaData metaData) {
        this.factory = new Supplier<Set<String>>(){

            @Override
            public Set<String> get() {
                if (metaData != null) {
                    String contextPath = metaData.getContextRoot();
                    TreeSet<String> servletNames = new TreeSet<String>();
                    for (JBossServletMetaData servlet : metaData.getServlets()) {
                        if (!WSFServlet.class.getName().equals(servlet.getServletClass())) continue;
                        servletNames.add(servlet.getName());
                    }
                    if (!servletNames.isEmpty()) {
                        TreeSet<String> paths = new TreeSet<String>();
                        for (ServletMappingMetaData mapping : metaData.getServletMappings()) {
                            if (!servletNames.contains(mapping.getServletName())) continue;
                            for (String path : mapping.getUrlPatterns()) {
                                paths.add((String)(contextPath != null ? contextPath + path : path));
                            }
                        }
                        if (!paths.isEmpty()) {
                            return paths;
                        }
                    }
                }
                return Set.of();
            }
        };
    }

    public boolean resolve(HttpServerExchange exchange) {
        return this.getPaths().contains(exchange.getRequestPath());
    }

    private Set<String> getPaths() {
        Set<String> paths = this.paths.get();
        return paths != null ? paths : this.paths.updateAndGet(this);
    }

    @Override
    public Set<String> apply(Set<String> paths) {
        return paths != null ? paths : this.factory.get();
    }
}

