/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.common;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.as.web.host.ApplicationContextWrapper;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JBossWebHost
implements WebHost,
Service<WebHost> {
    private final InjectedValue<VirtualHost> injectedHost = new InjectedValue();

    public WebDeploymentController addWebDeployment(WebDeploymentBuilder webDeploymentBuilder) throws Exception {
        Host host = ((VirtualHost)this.injectedHost.getValue()).getHost();
        StandardContext context = new StandardContext();
        context.setPath(webDeploymentBuilder.getContextRoot());
        context.addLifecycleListener((LifecycleListener)new ContextConfig());
        File docBase = webDeploymentBuilder.getDocumentRoot();
        if (!docBase.exists()) {
            docBase.mkdirs();
        }
        context.setDocBase(docBase.getPath());
        WebCtxLoader loader = new WebCtxLoader(webDeploymentBuilder.getClassLoader());
        loader.setContainer((Container)host);
        context.setLoader((Loader)loader);
        context.setInstanceManager((InstanceManager)new LocalInstanceManager(webDeploymentBuilder.getClassLoader()));
        for (ServletBuilder servlet : webDeploymentBuilder.getServlets()) {
            String servletName = servlet.getServletName();
            Map params = servlet.getInitParams();
            List urlPatterns = servlet.getUrlMappings();
            Wrapper wsfsWrapper = context.createWrapper();
            wsfsWrapper.setName(servletName);
            wsfsWrapper.setServlet(servlet.getServlet());
            wsfsWrapper.setServletClass(servlet.getServletClass().getName());
            for (Map.Entry param : params.entrySet()) {
                wsfsWrapper.addInitParameter((String)param.getKey(), (String)param.getValue());
            }
            wsfsWrapper.setParent((Container)context);
            context.addChild((Container)wsfsWrapper);
            for (String urlPattern : urlPatterns) {
                context.addServletMapping(urlPattern, servletName);
            }
            for (Map.Entry entry : webDeploymentBuilder.getMimeTypes().entrySet()) {
                context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
            }
            if (!servlet.isForceInit()) continue;
            wsfsWrapper.allocate();
        }
        return new WebDeploymentControllerImpl(context, host);
    }

    public InjectedValue<VirtualHost> getInjectedHost() {
        return this.injectedHost;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public WebHost getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static class WebDeploymentControllerImpl
    implements WebDeploymentController {
        private final StandardContext context;
        private final Host host;

        private WebDeploymentControllerImpl(StandardContext context, Host host) {
            this.context = context;
            this.host = host;
        }

        public void create() throws Exception {
            this.host.addChild((Container)this.context);
            this.context.create();
        }

        public void start() throws Exception {
            this.context.start();
        }

        public void stop() throws Exception {
            this.context.stop();
        }

        public void destroy() throws Exception {
            this.context.getParent().removeChild((Container)this.context);
            this.context.destroy();
        }
    }

    static class ShareableContext
    extends StandardContext {
        private volatile ApplicationContextWrapper wrapper;

        ShareableContext(ApplicationContextWrapper wrapper) {
            this.wrapper = wrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ApplicationContext getApplicationContext() {
            if (this.wrapper != null) {
                ShareableContext shareableContext = this;
                synchronized (shareableContext) {
                    if (this.wrapper != null) {
                        this.context = (ApplicationContext)this.wrapper.wrap((Object)this.getServletContext());
                        this.wrapper = null;
                    }
                }
            }
            return this.context;
        }
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        private final ClassLoader classloader;

        LocalInstanceManager(ClassLoader classloader) {
            this.classloader = classloader;
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            if (this.classloader == null) {
                return Class.forName(className).newInstance();
            }
            return this.classloader.loadClass(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

