/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.web.AddressToNameAddAdaptor;
import org.jboss.as.web.WebExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WebConnectorDefinition
extends ModelOnlyResourceDefinition {
    protected static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setXmlName("name")).setRequired(false)).build();
    protected static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    protected static final SimpleAttributeDefinition SCHEME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scheme", ModelType.STRING).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition EXECUTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("executor", ModelType.STRING).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1, true))).build();
    protected static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition ENABLE_LOOKUPS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-lookups", ModelType.BOOLEAN).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition PROXY_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("proxy-binding", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)new StringLengthValidator(1))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setAlternatives(new String[]{"proxy-name", "proxy-port"})).build();
    protected static final SimpleAttributeDefinition PROXY_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("proxy-name", ModelType.STRING).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setAllowExpression(true)).setAlternatives(new String[]{"proxy-binding"})).build();
    protected static final SimpleAttributeDefinition PROXY_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("proxy-port", ModelType.INT).setRequired(false)).setValidator((ParameterValidator)new IntRangeValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setAlternatives(new String[]{"proxy-binding"})).build();
    protected static final SimpleAttributeDefinition MAX_POST_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-post-size", ModelType.INT).setRequired(false)).setValidator((ParameterValidator)new IntRangeValidator(0, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(0x200000))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition MAX_SAVE_POST_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-save-post-size", ModelType.INT).setRequired(false)).setValidator((ParameterValidator)new IntRangeValidator(0, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(4096))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition SECURE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secure", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition REDIRECT_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("redirect-binding", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)new StringLengthValidator(1))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setAlternatives(new String[]{"redirect-port"})).build();
    protected static final SimpleAttributeDefinition REDIRECT_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("redirect-port", ModelType.INT).setRequired(false)).setValidator((ParameterValidator)new IntRangeValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(443))).setAlternatives(new String[]{"redirect-binding"})).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition MAX_CONNECTIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-connections", ModelType.INT).setRequired(false)).setValidator((ParameterValidator)new IntRangeValidator(1, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final StringListAttributeDefinition VIRTUAL_SERVER = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("virtual-server").setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setElementValidator((ParameterValidator)new StringLengthValidator(1, false))).build();
    protected static final AttributeDefinition[] CONNECTOR_ATTRIBUTES = new AttributeDefinition[]{PROTOCOL, SCHEME, SOCKET_BINDING, ENABLE_LOOKUPS, PROXY_BINDING, PROXY_NAME, PROXY_PORT, REDIRECT_BINDING, REDIRECT_PORT, SECURE, MAX_POST_SIZE, MAX_SAVE_POST_SIZE, ENABLED, EXECUTOR, MAX_CONNECTIONS, VIRTUAL_SERVER};
    static final WebConnectorDefinition INSTANCE = new WebConnectorDefinition();
    private static final List<AccessConstraintDefinition> ACCESS_CONSTRAINTS;
    private final String UNDERTOW_LISTENER_CAPABILITY_NAME = "org.wildfly.undertow.listener";
    private final RuntimeCapability<Void> FAKE_UNDERTOW_LISTENER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.listener", (boolean)true).setAllowMultipleRegistrations(true).build();

    private WebConnectorDefinition() {
        super(WebExtension.CONNECTOR_PATH, (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("connector"), (ModelOnlyAddStepHandler)new AddressToNameAddAdaptor(CONNECTOR_ATTRIBUTES), CONNECTOR_ATTRIBUTES);
        this.setDeprecated(WebExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration connectors) {
        super.registerAttributes(connectors);
        connectors.registerReadOnlyAttribute((AttributeDefinition)NAME, null);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return ACCESS_CONSTRAINTS;
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        super.registerCapabilities(resourceRegistration);
        resourceRegistration.registerCapability(this.FAKE_UNDERTOW_LISTENER_CAPABILITY);
    }

    static {
        ArrayList<SensitiveTargetAccessConstraintDefinition> constraints = new ArrayList<SensitiveTargetAccessConstraintDefinition>();
        constraints.add(WebExtension.WEB_CONNECTOR_CONSTRAINT);
        ACCESS_CONSTRAINTS = Collections.unmodifiableList(constraints);
    }
}

