/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service.internal.tsr;

import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.txn.logging.TransactionLogger;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ContextTransactionSynchronizationRegistry;

public class JCAOrderedLastSynchronizationList
implements Synchronization {
    private final List<Synchronization> preJcaSyncs = new ArrayList<Synchronization>();
    private final List<Synchronization> jcaSyncs = new ArrayList<Synchronization>();

    public void registerInterposedSynchronization(Synchronization synchronization) throws IllegalStateException, SystemException {
        int status = ContextTransactionSynchronizationRegistry.getInstance().getTransactionStatus();
        switch (status) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                return;
            }
            default: {
                throw TransactionLogger.ROOT_LOGGER.syncsnotallowed(status);
            }
        }
        if (synchronization.getClass().getName().startsWith("org.jboss.jca")) {
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.jcaSyncs.add - Class: " + String.valueOf(synchronization.getClass()) + " HashCode: " + synchronization.hashCode() + " toString: " + String.valueOf(synchronization));
            }
            this.jcaSyncs.add(synchronization);
        } else {
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.preJcaSyncs.add - Class: " + String.valueOf(synchronization.getClass()) + " HashCode: " + synchronization.hashCode() + " toString: " + String.valueOf(synchronization));
            }
            this.preJcaSyncs.add(synchronization);
        }
    }

    public void beforeCompletion() {
        int lastIndexProcessed;
        for (lastIndexProcessed = 0; lastIndexProcessed < this.preJcaSyncs.size(); ++lastIndexProcessed) {
            Synchronization preJcaSync = this.preJcaSyncs.get(lastIndexProcessed);
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.preJcaSyncs.before_completion - Class: " + String.valueOf(preJcaSync.getClass()) + " HashCode: " + preJcaSync.hashCode() + " toString: " + String.valueOf(preJcaSync));
            }
            preJcaSync.beforeCompletion();
        }
        for (lastIndexProcessed = 0; lastIndexProcessed < this.jcaSyncs.size(); ++lastIndexProcessed) {
            Synchronization jcaSync = this.jcaSyncs.get(lastIndexProcessed);
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.jcaSyncs.before_completion - Class: " + String.valueOf(jcaSync.getClass()) + " HashCode: " + jcaSync.hashCode() + " toString: " + String.valueOf(jcaSync));
            }
            jcaSync.beforeCompletion();
        }
    }

    public void afterCompletion(int status) {
        int i;
        for (i = this.preJcaSyncs.size() - 1; i >= 0; --i) {
            Synchronization preJcaSync = this.preJcaSyncs.get(i);
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.preJcaSyncs.afterCompletion - Class: " + String.valueOf(preJcaSync.getClass()) + " HashCode: " + preJcaSync.hashCode() + " toString: " + String.valueOf(preJcaSync));
            }
            try {
                preJcaSync.afterCompletion(status);
                continue;
            }
            catch (Exception e) {
                TransactionLogger.ROOT_LOGGER.preJcaSyncAfterCompletionFailed(preJcaSync, (Transaction)ContextTransactionManager.getInstance().getTransaction(), e);
            }
        }
        for (i = this.jcaSyncs.size() - 1; i >= 0; --i) {
            Synchronization jcaSync = this.jcaSyncs.get(i);
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.jcaSyncs.afterCompletion - Class: " + String.valueOf(jcaSync.getClass()) + " HashCode: " + jcaSync.hashCode() + " toString: " + String.valueOf(jcaSync));
            }
            try {
                jcaSync.afterCompletion(status);
                continue;
            }
            catch (Exception e) {
                TransactionLogger.ROOT_LOGGER.jcaSyncAfterCompletionFailed(jcaSync, (Transaction)ContextTransactionManager.getInstance().getTransaction(), e);
            }
        }
    }
}

