/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.MatchRules;

public class SimpleAuthContext
extends AbstractConfigurableElement {
    private final String extendsAttr;
    private final MatchRules matchRules;

    private SimpleAuthContext(Builder builder) {
        super(builder);
        this.extendsAttr = builder.extendsAttr;
        this.matchRules = builder.matchRules;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder sb = new StringBuilder("/subsystem=elytron/authentication-context=\"");
        sb.append(this.name).append("\":add(");
        if (this.extendsAttr != null && !this.extendsAttr.isEmpty()) {
            sb.append(String.format("extends=\"%s\", ", this.extendsAttr));
        }
        if (this.matchRules != null) {
            sb.append(this.matchRules.asString());
        }
        sb.append(")");
        cli.sendLine(sb.toString());
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/authentication-context=\"%s\":remove", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String extendsAttr;
        private MatchRules matchRules;

        private Builder() {
        }

        public Builder withExtends(String extendsAttr) {
            this.extendsAttr = extendsAttr;
            return this;
        }

        public Builder withMatchRules(MatchRules matchRules) {
            this.matchRules = matchRules;
            return this;
        }

        public SimpleAuthContext build() {
            return new SimpleAuthContext(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

