/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.web.sso;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jboss.as.test.http.util.TestHttpClientUtils;
import org.jboss.as.test.integration.web.sso.LogoutServlet;
import org.jboss.as.test.integration.web.sso.NotAnEJBServlet;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;

public final class SSOTestBase {
    public static final String USERNAME = "user1";
    public static final String PASSWORD = "password1";
    public static final String ROLE = "Users";

    private SSOTestBase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeFormAuthSingleSignOnTest(URL serverA, URL serverB, Logger log) throws Exception {
        URL warA1 = new URL(serverA, "/war1/");
        URL warB2 = new URL(serverB, "/war2/");
        BasicCookieStore store = new BasicCookieStore();
        CloseableHttpClient httpclient = TestHttpClientUtils.promiscuousCookieHttpClientBuilder().setDefaultCookieStore((CookieStore)store).disableRedirectHandling().build();
        try {
            SSOTestBase.checkAccessDenied((HttpClient)httpclient, warA1 + "index.html");
            log.debug((Object)("Saw JSESSIONID=" + SSOTestBase.getSessionIdValueFromState((CookieStore)store)));
            SSOTestBase.executeFormLogin((HttpClient)httpclient, warA1);
            String ssoID = SSOTestBase.processSSOCookie((CookieStore)store, serverA.toString(), serverB.toString());
            log.debug((Object)("Saw JSESSIONIDSSO=" + ssoID));
            log.debug((Object)"Prepare /war2/index.html get");
            SSOTestBase.checkAccessAllowed((HttpClient)httpclient, warB2 + "index.html");
            SSOTestBase.checkAccessAllowed((HttpClient)httpclient, warB2 + "NotAnEJBServlet");
            SSOTestBase.executeLogout((HttpClient)httpclient, warB2);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)httpclient);
        }
        try {
            httpclient = HttpClients.createDefault();
            SSOTestBase.checkAccessDenied((HttpClient)httpclient, warA1 + "index.html");
            SSOTestBase.checkAccessDenied((HttpClient)httpclient, warB2 + "index.html");
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)httpclient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeNoAuthSingleSignOnTest(URL serverA, URL serverB, Logger log) throws Exception {
        URL warA1 = new URL(serverA, "/war1/");
        URL warB2 = new URL(serverB + "/war2/");
        URL warB6 = new URL(serverB + "/war6/");
        BasicCookieStore store = new BasicCookieStore();
        CloseableHttpClient httpclient = TestHttpClientUtils.promiscuousCookieHttpClientBuilder().setDefaultCookieStore((CookieStore)store).build();
        try {
            SSOTestBase.checkAccessDenied((HttpClient)httpclient, warA1 + "index.html");
            log.debug((Object)("Saw JSESSIONID=" + SSOTestBase.getSessionIdValueFromState((CookieStore)store)));
            SSOTestBase.executeFormLogin((HttpClient)httpclient, warA1);
            String ssoID = SSOTestBase.processSSOCookie((CookieStore)store, serverA.toString(), serverB.toString());
            log.debug((Object)("Saw JSESSIONIDSSO=" + ssoID));
            log.debug((Object)"Prepare /war2/index.html get");
            SSOTestBase.checkAccessAllowed((HttpClient)httpclient, warB2 + "index.html");
            SSOTestBase.checkAccessAllowed((HttpClient)httpclient, warB2 + "NotAnEJBServlet");
            SSOTestBase.checkAccessDenied((HttpClient)httpclient, warB6 + "index.html");
            SSOTestBase.checkAccessAllowed((HttpClient)httpclient, warB2 + "NotAnEJBServlet");
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)httpclient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeFormAuthSSOTimeoutTest(URL serverA, URL serverB, Logger log) throws Exception {
        URL warA1 = new URL(serverA, "/war1/");
        URL warB2 = new URL(serverB, "/war2/");
        BasicCookieStore store = new BasicCookieStore();
        CloseableHttpClient httpclient = TestHttpClientUtils.promiscuousCookieHttpClientBuilder().setDefaultCookieStore((CookieStore)store).disableRedirectHandling().build();
        try {
            SSOTestBase.checkAccessDenied((HttpClient)httpclient, warA1 + "index.html");
            log.debug((Object)("Saw JSESSIONID=" + SSOTestBase.getSessionIdValueFromState((CookieStore)store)));
            SSOTestBase.executeFormLogin((HttpClient)httpclient, warA1);
            String ssoID = SSOTestBase.processSSOCookie((CookieStore)store, serverA.toString(), serverB.toString());
            log.debug((Object)("Saw JSESSIONIDSSO=" + ssoID));
            SSOTestBase.checkAccessAllowed((HttpClient)httpclient, warA1 + "set_session_timeout.jsp");
            SSOTestBase.checkAccessAllowed((HttpClient)httpclient, warB2 + "set_session_timeout.jsp");
            Thread.sleep(6000L);
            SSOTestBase.checkAccessDenied((HttpClient)httpclient, warA1 + "index.html");
            SSOTestBase.checkAccessDenied((HttpClient)httpclient, warB2 + "index.html");
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)httpclient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeLogout(HttpClient httpConn, URL warURL) throws IOException {
        HttpGet logout = new HttpGet(warURL + "Logout");
        HttpResponse response = httpConn.execute((HttpUriRequest)logout);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            Assert.assertTrue((String)("Logout: Didn't see code 302 (HTTP_MOVED_TEMP), but saw instead " + statusCode), (statusCode == 302 ? 1 : 0) != 0);
            Header location = response.getFirstHeader("Location");
            Assert.assertTrue((String)("Get of " + warURL + "Logout not redirected to login page"), (boolean)location.getValue().contains("index.html"));
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAccessAllowed(HttpClient httpConn, String url) throws IOException {
        HttpGet getMethod = new HttpGet(url);
        HttpResponse response = httpConn.execute((HttpUriRequest)getMethod);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            Assert.assertTrue((String)("Expected code == OK but got " + statusCode + " for request=" + url), (statusCode == 200 ? 1 : 0) != 0);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            Assert.assertTrue((String)("Get of " + url + " redirected to login page"), (!body.contains("j_security_check") ? 1 : 0) != 0);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeFormLogin(HttpClient httpConn, URL warURL) throws IOException {
        HttpPost formPost = new HttpPost(warURL + "j_security_check");
        formPost.addHeader("Referer", warURL + "login.html");
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("j_username", USERNAME));
        formparams.add(new BasicNameValuePair("j_password", PASSWORD));
        formPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams, StandardCharsets.UTF_8));
        HttpResponse postResponse = httpConn.execute((HttpUriRequest)formPost);
        try {
            int statusCode = postResponse.getStatusLine().getStatusCode();
            Object[] errorHeaders = postResponse.getHeaders("X-NoJException");
            Assert.assertTrue((String)("Should see HTTP_MOVED_TEMP. Got " + statusCode), (statusCode == 302 ? 1 : 0) != 0);
            Assert.assertTrue((String)("X-NoJException(" + Arrays.toString(errorHeaders) + ") is null"), (errorHeaders.length == 0 ? 1 : 0) != 0);
            EntityUtils.consume((HttpEntity)postResponse.getEntity());
            String indexURL = postResponse.getFirstHeader("Location").getValue();
            HttpGet rediretGet = new HttpGet(indexURL);
            HttpResponse redirectResponse = httpConn.execute((HttpUriRequest)rediretGet);
            statusCode = redirectResponse.getStatusLine().getStatusCode();
            errorHeaders = redirectResponse.getHeaders("X-NoJException");
            Assert.assertTrue((String)("Wrong response code: " + statusCode), (statusCode == 200 ? 1 : 0) != 0);
            Assert.assertTrue((String)("X-NoJException(" + Arrays.toString(errorHeaders) + ") is null"), (errorHeaders.length == 0 ? 1 : 0) != 0);
            String body = EntityUtils.toString((HttpEntity)redirectResponse.getEntity());
            Assert.assertTrue((String)("Get of " + indexURL + " redirected to login page"), (!body.contains("j_security_check") ? 1 : 0) != 0);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)postResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAccessDenied(HttpClient httpConn, String url) throws IOException {
        HttpGet getMethod = new HttpGet(url);
        HttpResponse response = httpConn.execute((HttpUriRequest)getMethod);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            Assert.assertTrue((String)("Expected code == OK but got " + statusCode + " for request=" + url), (statusCode == 200 ? 1 : 0) != 0);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            Assert.assertTrue((String)("Redirected to login page for request=" + url + ", body[" + body + "]"), (body.indexOf("j_security_check") > 0 ? 1 : 0) != 0);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
    }

    public static String processSSOCookie(CookieStore cookieStore, String serverA, String serverB) {
        String ssoID = null;
        for (Cookie cookie : cookieStore.getCookies()) {
            if (!"JSESSIONIDSSO".equalsIgnoreCase(cookie.getName())) continue;
            ssoID = cookie.getValue();
            if (serverA.equals(serverB)) continue;
            Cookie copy = SSOTestBase.copyCookie(cookie, serverB);
            cookieStore.addCookie(copy);
        }
        Assert.assertTrue((String)("Didn't see JSESSIONIDSSO: " + cookieStore.getCookies()), (ssoID != null ? 1 : 0) != 0);
        return ssoID;
    }

    public static Cookie copyCookie(Cookie toCopy, String targetServer) {
        int index = targetServer.indexOf("://");
        if (index > -1) {
            targetServer = targetServer.substring(index + 3);
        }
        if ((index = targetServer.lastIndexOf(":")) > -1) {
            targetServer = targetServer.substring(0, index);
        }
        if ((index = targetServer.indexOf("/")) > -1) {
            targetServer = targetServer.substring(0, index);
        }
        BasicClientCookie copy = new BasicClientCookie(toCopy.getName(), toCopy.getValue());
        copy.setDomain(targetServer);
        return copy;
    }

    public static String getSessionIdValueFromState(CookieStore cookieStore) {
        String sessionID = null;
        for (Cookie cookie : cookieStore.getCookies()) {
            if (!"JSESSIONID".equalsIgnoreCase(cookie.getName())) continue;
            sessionID = cookie.getValue();
            break;
        }
        return sessionID;
    }

    public static WebArchive createSsoWar(String warName) {
        return SSOTestBase.createSsoWar(warName, true);
    }

    public static WebArchive createSsoWar(String warName, boolean includeJBossWeb) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        String resourcesLocation = "org/jboss/as/test/integration/web/sso/resources/";
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)warName);
        war.setWebXML(tccl.getResource(resourcesLocation + "web-form-auth.xml"));
        if (includeJBossWeb) {
            war.addAsWebInfResource(tccl.getResource(resourcesLocation + "jboss-web.xml"), "jboss-web.xml");
        }
        war.addAsWebResource(tccl.getResource(resourcesLocation + "error.html"), "error.html");
        war.addAsWebResource(tccl.getResource(resourcesLocation + "index.html"), "index.html");
        war.addAsWebResource(tccl.getResource(resourcesLocation + "index.jsp"), "index.jsp");
        war.addAsWebResource(tccl.getResource(resourcesLocation + "set_session_timeout.jsp"), "set_session_timeout.jsp");
        war.addAsWebResource(tccl.getResource(resourcesLocation + "login.html"), "login.html");
        war.addClass(NotAnEJBServlet.class);
        war.addClass(LogoutServlet.class);
        return war;
    }

    public static EnterpriseArchive createSsoEar() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        String resourcesLocation = "org/jboss/as/test/integration/web/sso/resources/";
        WebArchive war1 = SSOTestBase.createSsoWar("sso-form-auth1.war");
        WebArchive war2 = SSOTestBase.createSsoWar("sso-form-auth2.war");
        WebArchive war3 = SSOTestBase.createSsoWar("sso-with-no-auth.war", false);
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"web-sso.ear");
        ear.setApplicationXML(tccl.getResource(resourcesLocation + "application.xml"));
        ear.addAsModule((Archive)war1);
        ear.addAsModule((Archive)war2);
        ear.addAsModule((Archive)war3);
        return ear;
    }
}

