/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.observability.setuptasks;

import org.jboss.arquillian.testcontainers.api.Testcontainer;
import org.jboss.arquillian.testcontainers.api.TestcontainersRequired;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.as.test.shared.observability.containers.OpenTelemetryCollectorContainer;
import org.jboss.as.test.shared.observability.setuptasks.AbstractSetupTask;
import org.jboss.dmr.ModelNode;

@TestcontainersRequired
public class MicrometerSetupTask
extends AbstractSetupTask {
    private static final ModelNode micrometerExtension = Operations.createAddress((String[])new String[]{"extension", "org.wildfly.extension.micrometer"});
    private static final ModelNode micrometerSubsystem = Operations.createAddress((String[])new String[]{"subsystem", "micrometer"});
    private static final ModelNode otlpRegistry = Operations.createAddress((String[])new String[]{"subsystem", "micrometer", "registry", "otlp"});
    @Testcontainer
    private OpenTelemetryCollectorContainer otelCollector;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.executeOp(managementClient, this.writeAttribute("undertow", "statistics-enabled", "true"));
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, micrometerExtension))) {
            this.executeOp(managementClient, Operations.createAddOperation((ModelNode)micrometerExtension));
        }
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, micrometerSubsystem))) {
            this.executeOp(managementClient, Operations.createAddOperation((ModelNode)micrometerSubsystem));
        }
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, otlpRegistry))) {
            ModelNode addOtlpOp = Operations.createAddOperation((ModelNode)otlpRegistry);
            addOtlpOp.get("endpoint").set(this.otelCollector.getOtlpHttpEndpoint() + "/v1/metrics");
            addOtlpOp.get("step").set("1");
            this.executeOp(managementClient, addOtlpOp);
        } else {
            this.executeOp(managementClient, this.writeAttribute(otlpRegistry, "endpoint", this.otelCollector.getOtlpHttpEndpoint() + "/v1/metrics"));
        }
        ServerReload.executeReloadAndWaitForCompletion(managementClient);
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        this.otelCollector.stop();
        this.executeOp(managementClient, this.clearAttribute("undertow", "statistics-enabled"));
        this.executeOp(managementClient, Operations.createRemoveOperation((ModelNode)micrometerSubsystem));
        this.executeOp(managementClient, Operations.createRemoveOperation((ModelNode)micrometerExtension));
        ServerReload.executeReloadAndWaitForCompletion(managementClient);
    }
}

