/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;

public class RetryTaskExecutor<T> {
    private static final long DEFAULT_RETRY_DELAY = 1000L;
    private static final int DEFAULT_RETRY_COUNT = 60;
    private Callable<T> task;

    public final T retryTask(Callable<T> task) throws TimeoutException {
        return this.retryTask(task, 60, 1000L);
    }

    public final T retryTask(Callable<T> task, int retryCount, long retryDelay) throws TimeoutException {
        while (retryCount > 0) {
            try {
                return task.call();
            }
            catch (Exception exception) {
                --retryCount;
                try {
                    Thread.sleep(retryDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new TimeoutException();
    }
}

