/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common.jms;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.FileUtil;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class ArtemisRunListener
extends RunListener {
    private ActiveMQServer server;
    private static final boolean PERSISTENCE = false;

    public static void main(String[] args) throws Exception {
        ArtemisRunListener listener = new ArtemisRunListener();
        try {
            listener.startServer();
            System.out.println("Server started, ready to start client test");
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader br = new BufferedReader(isr);
            System.out.println("OK");
            String line = br.readLine();
            if (line != null && "STOP".equals(line.trim())) {
                listener.stopServer();
                System.out.println("Server stopped");
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Throwable t) {
            StackTraceElement[] stackTrace;
            t.printStackTrace();
            String allStack = t.getCause().getMessage() + "|";
            for (StackTraceElement stackTraceElement : stackTrace = t.getCause().getStackTrace()) {
                allStack = allStack + stackTraceElement.toString() + "|";
            }
            System.out.println(allStack);
            System.out.println("KO");
            System.exit(1);
        }
    }

    private synchronized ActiveMQServer startServer() throws Exception {
        if (this.server == null) {
            Configuration config = new ConfigurationImpl().setName("Test-Broker").addAcceptorConfiguration("netty", this.getBrokerUrl()).setSecurityEnabled(false).setPersistenceEnabled(false).setJournalFileSize(0xA00000).setJournalDeviceBlockSize(Integer.valueOf(4096)).setJournalMinFiles(2).setJournalDatasync(true).setJournalPoolFiles(10).addConnectorConfiguration("netty", this.getBrokerUrl());
            File dataPlace = new File(this.getArtemisHome());
            FileUtil.deleteDirectory((File)dataPlace);
            config.setJournalDirectory(new File(dataPlace, "./journal").getAbsolutePath()).setPagingDirectory(new File(dataPlace, "./paging").getAbsolutePath()).setLargeMessagesDirectory(new File(dataPlace, "./largemessages").getAbsolutePath()).setBindingsDirectory(new File(dataPlace, "./bindings").getAbsolutePath()).setPersistenceEnabled(true);
            this.server = ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false);
            this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDeadLetterAddress(SimpleString.toSimpleString((String)"DLQ")).setExpiryAddress(SimpleString.toSimpleString((String)"ExpiryQueue")).setRedeliveryDelay(0L).setMaxSizeBytes(-1L).setMessageCounterHistoryDayLimit(10).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateJmsQueues(true).setAutoCreateJmsTopics(true));
            this.server.getAddressSettingsRepository().addMatch("activemq.management#", (Object)new AddressSettings().setDeadLetterAddress(SimpleString.toSimpleString((String)"DLQ")).setExpiryAddress(SimpleString.toSimpleString((String)"ExpiryQueue")).setRedeliveryDelay(0L).setMaxSizeBytes(-1L).setMessageCounterHistoryDayLimit(10).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateJmsQueues(true).setAutoCreateJmsTopics(true));
            this.server.start();
            this.server.waitForActivation(10L, TimeUnit.SECONDS);
        }
        return this.server;
    }

    public void testRunFinished(Result result) throws Exception {
        this.stopServer();
        super.testRunFinished(result);
    }

    public void testRunStarted(Description description) throws Exception {
        this.startServer();
        super.testRunStarted(description);
    }

    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
    }

    private String getArtemisHome() {
        String artemisHome = System.getProperty("artemis.dist");
        if (artemisHome == null) {
            artemisHome = System.getProperty("artemis.home");
        }
        return artemisHome == null ? System.getenv("ARTEMIS_HOME") : artemisHome;
    }

    private synchronized void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.server = null;
    }

    private String getBrokerUrl() {
        return "tcp://" + this.getServerAddress() + ":" + this.getServerPort();
    }

    private String getServerAddress() {
        String address = System.getProperty("management.address");
        if (address == null) {
            address = System.getProperty("node0");
        }
        if (address != null) {
            return this.formatPossibleIpv6Address(address);
        }
        return "localhost";
    }

    private String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    private int getServerPort() {
        return Integer.getInteger("artemis.port", 61616);
    }
}

