/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.other;

import java.util.Objects;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;

public class ClientMapping {
    private final String sourceNetwork;
    private final String destinationAddress;
    private final Integer destinationPort;

    private ClientMapping(Builder builder) {
        this.sourceNetwork = builder.sourceNetwork;
        this.destinationAddress = Objects.requireNonNull(builder.destinationAddress, "Destination address has to be provided");
        this.destinationPort = builder.destinationPort;
    }

    public String getSourceNetwork() {
        return this.sourceNetwork;
    }

    public String getDestinationAddress() {
        return this.destinationAddress;
    }

    public Integer getDestinationPort() {
        return this.destinationPort;
    }

    public ModelNode toModelNode() {
        ModelNode node = new ModelNode();
        ModelNodeUtil.setIfNotNull(node, "source-network", this.sourceNetwork);
        ModelNodeUtil.setIfNotNull(node, "destination-address", this.destinationAddress);
        ModelNodeUtil.setIfNotNull(node, "destination-port", this.destinationPort);
        return node;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String sourceNetwork;
        private String destinationAddress;
        private Integer destinationPort;

        private Builder() {
        }

        public Builder withSourceNetwork(String sourceNetwork) {
            this.sourceNetwork = sourceNetwork;
            return this;
        }

        public Builder withDestinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public Builder withDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public ClientMapping build() {
            return new ClientMapping(this);
        }
    }
}

