/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.resources.ServerDeploymentResourceDefinition;
import org.jboss.as.server.operations.RootResourceHack;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.dmr.ModelNode;
import org.jboss.vfs.VirtualFile;

class TestModelControllerService
extends ModelTestModelControllerService {
    private final Extension mainExtension;
    private final AdditionalInitialization additionalInit;
    private final ControllerInitializer controllerInitializer;
    private final ExtensionRegistry extensionRegistry;
    private final RunningModeControl runningModeControl;
    private final ContentRepository contentRepository = new MockContentRepository();
    private final boolean registerTransformers;

    protected TestModelControllerService(Extension mainExtension, ControllerInitializer controllerInitializer, AdditionalInitialization additionalInit, RunningModeControl runningModeControl, ExtensionRegistry extensionRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, boolean registerTransformers) {
        super(additionalInit.getProcessType(), runningModeControl, extensionRegistry.getTransformerRegistry(), persister, validateOpsFilter, ModelTestModelControllerService.DESC_PROVIDER, new ControlledProcessState(true));
        this.mainExtension = mainExtension;
        this.additionalInit = additionalInit;
        this.controllerInitializer = controllerInitializer;
        this.extensionRegistry = extensionRegistry;
        this.runningModeControl = runningModeControl;
        this.registerTransformers = registerTransformers;
    }

    static TestModelControllerService create(Extension mainExtension, ControllerInitializer controllerInitializer, AdditionalInitialization additionalInit, ExtensionRegistry extensionRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, boolean registerTransformers) {
        return new TestModelControllerService(mainExtension, controllerInitializer, additionalInit, new RunningModeControl(additionalInit.getRunningMode()), extensionRegistry, persister, validateOpsFilter, registerTransformers);
    }

    protected void initExtraModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        rootResource.getModel().get("subsystem");
        ManagementResourceRegistration deployments = rootRegistration.registerSubModel((ResourceDefinition)ServerDeploymentResourceDefinition.create((ContentRepository)this.contentRepository, null));
        rootRegistration.registerOperationHandler(RootResourceHack.DEFINITION, (OperationStepHandler)RootResourceHack.INSTANCE);
        this.extensionRegistry.setSubsystemParentResourceRegistrations(rootRegistration, deployments);
        this.controllerInitializer.setTestModelControllerService(this);
        this.controllerInitializer.initializeModel(rootResource, rootRegistration);
        this.additionalInit.initializeExtraSubystemsAndModel(this.extensionRegistry, rootResource, rootRegistration);
    }

    protected void preBoot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) {
        this.mainExtension.initialize(this.extensionRegistry.getExtensionContext("Test", this.registerTransformers));
    }

    protected void postBoot() {
        DeployerChainAddHandler.INSTANCE.clearDeployerMap();
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        file.delete();
    }

    ServerEnvironment getServerEnvironment() {
        Properties props = new Properties();
        File home = new File("target/jbossas");
        this.delete(home);
        home.mkdir();
        props.put("jboss.home.dir", home.getAbsolutePath());
        File standalone = new File(home, "standalone");
        standalone.mkdir();
        props.put("jboss.server.base.dir", standalone.getAbsolutePath());
        File configuration = new File(standalone, "configuration");
        configuration.mkdir();
        props.put("jboss.server.config.dir", configuration.getAbsolutePath());
        File xml = new File(configuration, "standalone.xml");
        try {
            xml.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        props.put("jboss.server.default.config", "standalone.xml");
        return new ServerEnvironment(null, props, new HashMap(), "standalone.xml", null, ServerEnvironment.LaunchType.STANDALONE, this.runningModeControl.getRunningMode(), null);
    }

    private static class MockContentRepository
    implements ContentRepository {
        private MockContentRepository() {
        }

        public byte[] addContent(InputStream stream) throws IOException {
            return null;
        }

        public VirtualFile getContent(byte[] hash) {
            return null;
        }

        public boolean hasContent(byte[] hash) {
            return false;
        }

        public boolean syncContent(byte[] hash) {
            return false;
        }

        public void removeContent(byte[] hash, Object reference) {
        }

        public void addContentReference(byte[] hash, Object reference) {
        }
    }
}

