/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyRemoveStepHandler;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.security.SecurityDomainAdd;
import org.jboss.as.security.SecurityExtension;
import org.jboss.dmr.ModelType;

class SecurityDomainResourceDefinition
extends SimpleResourceDefinition {
    static final String CACHE_CONTAINER_BASE_CAPABILTIY = "org.wildfly.clustering.infinispan.cache-container";
    static final String CACHE_CONTAINER_NAME = "security";
    static final String INFINISPAN_CACHE_TYPE = "infinispan";
    static final RuntimeCapability<Void> LEGACY_SECURITY_DOMAIN = RuntimeCapability.Builder.of((String)"org.wildfly.security.legacy-security-domain", (boolean)true).build();
    public static final SimpleAttributeDefinition CACHE_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-type", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"default", "infinispan"}))).build();
    private final List<AccessConstraintDefinition> accessConstraints;

    SecurityDomainResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(SecurityExtension.SECURITY_DOMAIN_PATH, (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("security-domain")).setAddHandler((OperationStepHandler)SecurityDomainAdd.INSTANCE).setRemoveHandler((OperationStepHandler)ModelOnlyRemoveStepHandler.INSTANCE).setCapabilities(new RuntimeCapability[]{LEGACY_SECURITY_DOMAIN}));
        ApplicationTypeConfig atc = new ApplicationTypeConfig(CACHE_CONTAINER_NAME, "security-domain");
        ApplicationTypeAccessConstraintDefinition acd = new ApplicationTypeAccessConstraintDefinition(atc);
        this.accessConstraints = Arrays.asList(SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN, acd);
        this.setDeprecated(SecurityExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CACHE_TYPE, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{CACHE_TYPE}));
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

