/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolConnectionUtils;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;

public class ProtocolChannelClient
implements Closeable {
    private final Configuration configuration;

    private ProtocolChannelClient(Configuration configuration) {
        this.configuration = configuration;
    }

    public static ProtocolChannelClient create(Configuration configuration) throws IOException {
        if (configuration == null) {
            throw ProtocolMessages.MESSAGES.nullVar("configuration");
        }
        configuration.validate();
        return new ProtocolChannelClient(configuration);
    }

    public IoFuture<Connection> connect(CallbackHandler handler) throws IOException {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(this.configuration);
        config.setCallbackHandler(handler);
        return ProtocolConnectionUtils.connect(config);
    }

    public IoFuture<Connection> connect(CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext) throws IOException {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(this.configuration);
        config.setCallbackHandler(handler);
        config.setSaslOptions(saslOptions);
        config.setSslContext(sslContext);
        return ProtocolConnectionUtils.connect(config);
    }

    public Connection connectSync(CallbackHandler handler) throws IOException {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(this.configuration);
        config.setCallbackHandler(handler);
        return ProtocolConnectionUtils.connectSync(config);
    }

    public Connection connectSync(CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext) throws IOException {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(this.configuration);
        config.setCallbackHandler(handler);
        config.setSaslOptions(saslOptions);
        config.setSslContext(sslContext);
        return ProtocolConnectionUtils.connectSync(config);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void close() {
    }

    public static final class Configuration
    extends ProtocolConnectionConfiguration {
        public static final int WINDOW_SIZE = 32768;
        private static volatile boolean warnedExecutor;

        @Deprecated
        public void setExecutor(Executor readExecutor) {
            boolean warned = warnedExecutor;
            if (!warned) {
                warnedExecutor = true;
                ProtocolLogger.CLIENT_LOGGER.executorNotNeeded();
            }
        }
    }
}

