/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanMessages;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

class PlatformLoggingMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final PlatformLoggingMXBeanAttributeHandler INSTANCE = new PlatformLoggingMXBeanAttributeHandler();

    private PlatformLoggingMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        if ("object-name".equals(name)) {
            context.getResult().set("java.util.logging:type=Logging");
        } else if ("logger-names".equals(name)) {
            String[] names = (String[])PlatformMBeanUtil.getMBeanAttribute(PlatformMBeanConstants.PLATFORM_LOGGING_OBJECT_NAME, "LoggerNames");
            ModelNode result = context.getResult();
            result.setEmptyList();
            for (String loggerName : names) {
                result.add(loggerName);
            }
        } else {
            if (PlatformMBeanConstants.LOGGING_READ_ATTRIBUTES.contains(name)) {
                throw PlatformMBeanMessages.MESSAGES.badReadAttributeImpl9(name);
            }
            throw PlatformLoggingMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw PlatformLoggingMXBeanAttributeHandler.unknownAttribute(operation);
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        for (String attribute : PlatformMBeanConstants.LOGGING_READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
    }
}

