/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import javax.management.ObjectName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanMessages;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

class BufferPoolMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final BufferPoolMXBeanAttributeHandler INSTANCE = new BufferPoolMXBeanAttributeHandler();

    private BufferPoolMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String bpName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ObjectName objectName = PlatformMBeanUtil.getObjectNameWithNameKey("java.nio:type=BufferPool", bpName);
        if (!ManagementFactory.getPlatformMBeanServer().isRegistered(objectName)) {
            throw PlatformMBeanMessages.MESSAGES.unknownBufferPool(bpName);
        }
        String name = operation.require("name").asString();
        if ("object-name".equals(name)) {
            context.getResult().set(objectName.toString());
        } else if ("name".equals(name)) {
            context.getResult().set(PlatformMBeanUtil.getMBeanAttribute(objectName, "Name").toString());
        } else if ("count".equals(name)) {
            context.getResult().set(((Long)Long.class.cast(PlatformMBeanUtil.getMBeanAttribute(objectName, "Count"))).longValue());
        } else if ("memory-used".equals(name)) {
            context.getResult().set(((Long)Long.class.cast(PlatformMBeanUtil.getMBeanAttribute(objectName, "MemoryUsed"))).longValue());
        } else if ("total-capacity".equals(name)) {
            context.getResult().set(((Long)Long.class.cast(PlatformMBeanUtil.getMBeanAttribute(objectName, "TotalCapacity"))).longValue());
        } else {
            if (PlatformMBeanConstants.BUFFER_POOL_METRICS.contains(name)) {
                throw PlatformMBeanMessages.MESSAGES.badReadAttributeImpl1(name);
            }
            throw BufferPoolMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw BufferPoolMXBeanAttributeHandler.unknownAttribute(operation);
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        for (String attribute : PlatformMBeanConstants.BUFFER_POOL_READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.BUFFER_POOL_METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
    }
}

