/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.prometheus;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerSubsystemRegistrar;
import org.wildfly.extension.micrometer.prometheus.WildFlyPrometheusRegistry;
import org.wildfly.extension.micrometer.registry.WildFlyCompositeRegistry;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class PrometheusRegistryDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    private static final Stability FEATURE_STABILITY = Stability.COMMUNITY;
    public static final String NAME = "prometheus";
    public static final PathElement PATH = PathElement.pathElement((String)"registry", (String)"prometheus");
    public static final ResourceRegistration RESOURCE_REGISTRATION = ResourceRegistration.of((PathElement)PATH, (Stability)FEATURE_STABILITY);
    public static final String HTTP_EXTENSIBILITY_CAPABILITY = "org.wildfly.management.http.extensible";
    public static final SimpleAttributeDefinition CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"context", (ModelType)ModelType.STRING).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition SECURITY_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(ModelNode.TRUE)).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(CONTEXT, SECURITY_ENABLED);
    private final WildFlyCompositeRegistry wildFlyRegistry;

    public PrometheusRegistryDefinitionRegistrar(WildFlyCompositeRegistry wildFlyRegistry) {
        this.wildFlyRegistry = wildFlyRegistry;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceDescriptor description = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)MicrometerSubsystemRegistrar.RESOLVER.createChildResolver(PATH)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).withOperationTransformation("add", (UnaryOperator)new UnaryOperator<OperationStepHandler>(){

            @Override
            public OperationStepHandler apply(OperationStepHandler handler) {
                return (context, operation) -> {
                    if (context.getProcessType().isHostController()) {
                        throw MicrometerExtensionLogger.MICROMETER_LOGGER.prometheusNotSupportedOnHostControllers();
                    }
                    handler.execute(context, operation);
                };
            }
        })).build();
        ManagementResourceRegistration resourceRegistration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)RESOURCE_REGISTRATION, (ResourceDescriptionResolver)description.getResourceDescriptionResolver()).build());
        if (resourceRegistration != null) {
            resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"io.prometheus")});
        }
        ManagementResourceRegistrar.of((ResourceDescriptor)description).register(resourceRegistration);
        return resourceRegistration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String serviceContext = CONTEXT.resolveModelAttribute(context, model).asString();
        boolean securityEnabled = SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean();
        return (ResourceServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)ServiceDependency.on((String)HTTP_EXTENSIBILITY_CAPABILITY, ExtensibleHttpManagement.class, (String[])new String[0])).onStart(ehm -> {
            WildFlyPrometheusRegistry prometheusRegistry = new WildFlyPrometheusRegistry();
            this.wildFlyRegistry.add((MeterRegistry)prometheusRegistry);
            ehm.addManagementHandler(serviceContext, securityEnabled, exchange -> exchange.getResponseSender().send(prometheusRegistry.scrape()));
        })).asActive()).build();
    }
}

