/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.core.security.Role;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.as.messaging.SecurityRoleAttributeHandler;
import org.jboss.as.messaging.SecurityRoleReadAttributeHandler;
import org.jboss.as.messaging.SecurityRoleRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SecurityRoleDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition SEND = SecurityRoleDefinition.create("send", "send");
    static final SimpleAttributeDefinition CONSUME = SecurityRoleDefinition.create("consume", "consume");
    static final SimpleAttributeDefinition CREATE_DURABLE_QUEUE = SecurityRoleDefinition.create("create-durable-queue", "createDurableQueue");
    static final SimpleAttributeDefinition DELETE_DURABLE_QUEUE = SecurityRoleDefinition.create("delete-durable-queue", "deleteDurableQueue");
    static final SimpleAttributeDefinition CREATE_NON_DURABLE_QUEUE = SecurityRoleDefinition.create("create-non-durable-queue", "createNonDurableQueue");
    static final SimpleAttributeDefinition DELETE_NON_DURABLE_QUEUE = SecurityRoleDefinition.create("delete-non-durable-queue", "deleteNonDurableQueue");
    static final SimpleAttributeDefinition MANAGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"manage", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_MANAGEMENT_DEF)).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{SEND, CONSUME, CREATE_DURABLE_QUEUE, DELETE_DURABLE_QUEUE, CREATE_NON_DURABLE_QUEUE, DELETE_NON_DURABLE_QUEUE, MANAGE};
    static final SimpleAttributeDefinition NAME = SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).build();
    static final Map<String, AttributeDefinition> ROLE_ATTRIBUTES_BY_XML_NAME;
    private final boolean registerRuntimeOnly;
    private final boolean readOnly;

    public static ObjectTypeAttributeDefinition getObjectTypeAttributeDefinition() {
        SimpleAttributeDefinition[] attrs = new SimpleAttributeDefinition[ATTRIBUTES.length + 1];
        attrs[0] = NAME;
        System.arraycopy(ATTRIBUTES, 0, attrs, 1, ATTRIBUTES.length);
        return ObjectTypeAttributeDefinition.Builder.of((String)"role", (AttributeDefinition[])attrs).build();
    }

    private static SimpleAttributeDefinition create(String name, String xmlName) {
        return ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)name, (ModelType)ModelType.BOOLEAN).setXmlName(xmlName)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
    }

    static Role transform(OperationContext context, String name, ModelNode node) throws OperationFailedException {
        boolean send = SEND.resolveModelAttribute(context, node).asBoolean();
        boolean consume = CONSUME.resolveModelAttribute(context, node).asBoolean();
        boolean createDurableQueue = CREATE_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean deleteDurableQueue = DELETE_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean createNonDurableQueue = CREATE_NON_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean deleteNonDurableQueue = DELETE_NON_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean manage = MANAGE.resolveModelAttribute(context, node).asBoolean();
        return new Role(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage);
    }

    public static SecurityRoleDefinition newReadOnlySecurityRoleDefinition() {
        return new SecurityRoleDefinition(true, true, null, null);
    }

    public static SecurityRoleDefinition newSecurityRoleDefinition(boolean registerRuntimeOnly) {
        return new SecurityRoleDefinition(registerRuntimeOnly, false, (OperationStepHandler)SecurityRoleAdd.INSTANCE, (OperationStepHandler)SecurityRoleRemove.INSTANCE);
    }

    private SecurityRoleDefinition(boolean registerRuntimeOnly, boolean readOnly, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PathElement.pathElement((String)"role"), MessagingExtension.getResourceDescriptionResolver("security-role"), addHandler, removeHandler);
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.readOnly = readOnly;
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        if (this.readOnly) {
            for (SimpleAttributeDefinition attr : ATTRIBUTES) {
                SimpleAttributeDefinition readOnlyAttr = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)attr).setStorageRuntime()).build();
                registry.registerReadOnlyAttribute((AttributeDefinition)readOnlyAttr, (OperationStepHandler)SecurityRoleReadAttributeHandler.INSTANCE);
            }
        } else {
            for (SimpleAttributeDefinition attr : ATTRIBUTES) {
                if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
                registry.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)SecurityRoleAttributeHandler.INSTANCE);
            }
        }
    }

    static {
        HashMap<String, SimpleAttributeDefinition> robxn = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            robxn.put(attr.getXmlName(), attr);
        }
        robxn.put("createTempQueue", CREATE_NON_DURABLE_QUEUE);
        robxn.put("deleteTempQueue", DELETE_NON_DURABLE_QUEUE);
        ROLE_ATTRIBUTES_BY_XML_NAME = Collections.unmodifiableMap(robxn);
    }
}

