/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.HTTPUpgradeService;
import org.jboss.as.messaging.HornetQReloadRequiredHandlers;
import org.jboss.dmr.ModelNode;

public class HTTPAcceptorAdd
extends HornetQReloadRequiredHandlers.AddStepHandler {
    public static final HTTPAcceptorAdd INSTANCE = new HTTPAcceptorAdd();

    private HTTPAcceptorAdd() {
        super(HTTPAcceptorDefinition.ATTRIBUTES);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performRuntime(context, operation, model);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String hornetqServerName = address.getElement(address.size() - 2).getValue();
        String acceptorName = address.getLastElement().getValue();
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        this.launchServices(context, hornetqServerName, acceptorName, fullModel);
    }

    void launchServices(OperationContext context, String hornetqServerName, String acceptorName, ModelNode model) throws OperationFailedException {
        String httpConnectorName = HTTPAcceptorDefinition.HTTP_LISTENER.resolveModelAttribute(context, model).asString();
        HTTPUpgradeService.installService(context.getServiceTarget(), hornetqServerName, acceptorName, httpConnectorName);
    }
}

