/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.List;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConnectorServiceConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceParamDefinition;
import org.jboss.as.messaging.HornetQReloadRequiredHandlers;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ConnectorServiceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"connector-service");
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FACTORY_CLASS};
    private final boolean registerRuntimeOnly;

    public ConnectorServiceDefinition(boolean registerRuntimeOnly) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver(false, "connector-service"), (OperationStepHandler)new HornetQReloadRequiredHandlers.AddStepHandler(ATTRIBUTES), (OperationStepHandler)new HornetQReloadRequiredHandlers.RemoveStepHandler());
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }

    static void addConnectorServiceConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("connector-service")) {
            List configs = configuration.getConnectorServiceConfigurations();
            for (Property prop : model.get("connector-service").asPropertyList()) {
                configs.add(ConnectorServiceDefinition.createConnectorServiceConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static ConnectorServiceConfiguration createConnectorServiceConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String factoryClass = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, model).asString();
        HashMap<String, String> params = new HashMap<String, String>();
        if (model.hasDefined("param")) {
            for (Property property : model.get("param").asPropertyList()) {
                String value = ConnectorServiceParamDefinition.VALUE.resolveModelAttribute(context, property.getValue()).asString();
                params.put(property.getName(), value);
            }
        }
        return new ConnectorServiceConfiguration(factoryClass, params, name);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerChildren(ManagementResourceRegistration registry) {
        registry.registerSubModel((ResourceDefinition)new ConnectorServiceParamDefinition());
    }
}

