/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.JGroupsBroadcastGroupConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.GroupBindingService;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.OperationValidator;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jgroups.JChannel;

public class DiscoveryGroupAdd
extends AbstractAddStepHandler {
    private static final OperationValidator VALIDATOR = new OperationValidator.AttributeDefinitionOperationValidator(DiscoveryGroupDefinition.ATTRIBUTES);
    public static final DiscoveryGroupAdd INSTANCE = new DiscoveryGroupAdd();

    private DiscoveryGroupAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        VALIDATOR.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName hqServiceName;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null) {
            context.reloadRequired();
        } else {
            ServiceTarget target = context.getServiceTarget();
            if (!model.hasDefined(CommonAttributes.JGROUPS_STACK.getName())) {
                if (model.hasDefined(RemoteTransportDefinition.SOCKET_BINDING.getName())) {
                    GroupBindingService bindingService = new GroupBindingService();
                    target.addService(GroupBindingService.getDiscoveryBaseServiceName(hqServiceName).append(new String[]{name}), (Service)bindingService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get("socket-binding").asString()}), SocketBinding.class, bindingService.getBindingRef()).install();
                } else {
                    ModelNode localAddrNode = CommonAttributes.LOCAL_BIND_ADDRESS.resolveModelAttribute(context, model);
                    String localAddress = localAddrNode.isDefined() ? localAddrNode.asString() : null;
                    ModelNode groupAddrNode = CommonAttributes.GROUP_ADDRESS.resolveModelAttribute(context, model);
                    String groupAddress = groupAddrNode.isDefined() ? groupAddrNode.asString() : null;
                    ModelNode groupPortNode = CommonAttributes.GROUP_PORT.resolveModelAttribute(context, model);
                    int groupPort = groupPortNode.isDefined() ? groupPortNode.asInt() : -1;
                    try {
                        InetAddress inet = localAddress != null ? InetAddress.getByName(localAddress) : InetAddressUtil.getLocalHost();
                        NetworkInterface intf = NetworkInterface.getByInetAddress(inet);
                        NetworkInterfaceBinding b = new NetworkInterfaceBinding(Collections.singleton(intf), inet);
                        InetAddress group = InetAddress.getByName(groupAddress);
                        SocketBinding socketBinding = new SocketBinding(name, -1, false, group, groupPort, b, null, null);
                        GroupBindingService bindingService = new GroupBindingService();
                        target.addService(GroupBindingService.getDiscoveryBaseServiceName(hqServiceName).append(new String[]{name}), (Service)bindingService).addInjectionValue(bindingService.getBindingRef(), (Value)new ImmediateValue((Object)socketBinding)).install();
                    }
                    catch (Exception e) {
                        throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
                    }
                }
            }
        }
    }

    static void addDiscoveryGroupConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("discovery-group")) {
            HashMap<String, DiscoveryGroupConfiguration> configs = configuration.getDiscoveryGroupConfigurations();
            if (configs == null) {
                configs = new HashMap<String, DiscoveryGroupConfiguration>();
                configuration.setDiscoveryGroupConfigurations(configs);
            }
            for (Property prop : model.get("discovery-group").asPropertyList()) {
                configs.put(prop.getName(), DiscoveryGroupAdd.createDiscoveryGroupConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        long refreshTimeout = DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long initialWaitTimeout = DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        return new DiscoveryGroupConfiguration(name, refreshTimeout, initialWaitTimeout, null);
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(String name, DiscoveryGroupConfiguration config, SocketBinding socketBinding) throws Exception {
        String localAddress = socketBinding.getAddress().getHostAddress();
        String groupAddress = socketBinding.getMulticastAddress().getHostAddress();
        int groupPort = socketBinding.getMulticastPort();
        long refreshTimeout = config.getRefreshTimeout();
        long initialWaitTimeout = config.getDiscoveryInitialWaitTimeout();
        UDPBroadcastGroupConfiguration endpointFactoryConfiguration = new UDPBroadcastGroupConfiguration(groupAddress, groupPort, localAddress, -1);
        return new DiscoveryGroupConfiguration(name, refreshTimeout, initialWaitTimeout, (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(String name, DiscoveryGroupConfiguration config, JChannel channel, String channelName) throws Exception {
        long refreshTimeout = config.getRefreshTimeout();
        long initialWaitTimeout = config.getDiscoveryInitialWaitTimeout();
        JGroupsBroadcastGroupConfiguration endpointFactoryConfiguration = new JGroupsBroadcastGroupConfiguration(channel, channelName);
        return new DiscoveryGroupConfiguration(name, refreshTimeout, initialWaitTimeout, (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
    }
}

