/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.ServletConnectorDefinition;
import org.jboss.as.messaging.ServletConnectorService;
import org.jboss.as.messaging.TransportConfigOperationHandlers;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ServletConnectorAdd
extends TransportConfigOperationHandlers.BasicTransportConfigAdd
implements DescriptionProvider {
    static final OperationStepHandler INSTANCE = new ServletConnectorAdd();

    private ServletConnectorAdd() {
        super(false, ServletConnectorDefinition.ATTRIBUTES);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        super.performRuntime(context, operation, model, verificationHandler, newControllers);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String hornetqServerName = address.getElement(address.size() - 2).getValue();
        String connectorName = address.getLastElement().getValue();
        String host = ServletConnectorDefinition.HOST.resolveModelAttribute(context, model).asString();
        ServiceController<ServletConnectorService> serviceController = ServletConnectorService.addService(context.getServiceTarget(), verificationHandler, host, hornetqServerName, connectorName);
        newControllers.add(serviceController);
    }
}

