/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.QueueControlHandler;
import org.jboss.as.messaging.QueueReadAttributeHandler;
import org.jboss.as.messaging.QueueRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class QueueDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"queue");
    public static final SimpleAttributeDefinition ADDRESS = SimpleAttributeDefinitionBuilder.create((String)"queue-address", (ModelType)ModelType.STRING).setXmlName("address").setAllowExpression(true).setRestartAllServices().build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{ADDRESS, CommonAttributes.FILTER, CommonAttributes.DURABLE};
    public static final SimpleAttributeDefinition EXPIRY_ADDRESS = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.EXPIRY_ADDRESS).setStorageRuntime().build();
    public static final SimpleAttributeDefinition DEAD_LETTER_ADDRESS = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.DEAD_LETTER_ADDRESS).setStorageRuntime().build();
    static final AttributeDefinition ID = SimpleAttributeDefinitionBuilder.create((String)"id", (ModelType)ModelType.LONG).setStorageRuntime().build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.PAUSED, CommonAttributes.TEMPORARY, ID, DEAD_LETTER_ADDRESS, EXPIRY_ADDRESS};
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.MESSAGE_COUNT, CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.SCHEDULED_COUNT, CommonAttributes.CONSUMER_COUNT};
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{ADDRESS, CommonAttributes.FILTER, CommonAttributes.DURABLE};
    private final boolean registerRuntimeOnly;
    private final boolean runtimeOnly;
    private final List<AccessConstraintDefinition> accessConstraints;

    public static QueueDefinition newRuntimeQueueDefinition(boolean registerRuntimeOnly) {
        return new QueueDefinition(registerRuntimeOnly, true, "runtime-queue", null, null);
    }

    public static QueueDefinition newQueueDefinition(boolean registerRuntimeOnly) {
        return new QueueDefinition(registerRuntimeOnly, false, "queue", QueueAdd.INSTANCE, (OperationStepHandler)QueueRemove.INSTANCE);
    }

    private QueueDefinition(boolean registerRuntimeOnly, boolean runtimeOnly, String path, AbstractAddStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PathElement.pathElement((String)path), MessagingExtension.getResourceDescriptionResolver("queue"), (OperationStepHandler)addHandler, removeHandler);
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.runtimeOnly = runtimeOnly;
        if (!runtimeOnly) {
            ApplicationTypeConfig atc = new ApplicationTypeConfig("messaging", path);
            this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
        } else {
            this.accessConstraints = Collections.emptyList();
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (SimpleAttributeDefinition simpleAttributeDefinition : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && simpleAttributeDefinition.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (this.runtimeOnly) {
                SimpleAttributeDefinition readOnlyRuntimeAttr = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)simpleAttributeDefinition).setStorageRuntime().build();
                registry.registerReadOnlyAttribute((AttributeDefinition)readOnlyRuntimeAttr, (OperationStepHandler)QueueReadAttributeHandler.RUNTIME_INSTANCE);
                continue;
            }
            registry.registerReadOnlyAttribute((AttributeDefinition)simpleAttributeDefinition, null);
        }
        if (this.registerRuntimeOnly) {
            for (SimpleAttributeDefinition simpleAttributeDefinition : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute((AttributeDefinition)simpleAttributeDefinition, (OperationStepHandler)QueueReadAttributeHandler.INSTANCE);
            }
            for (SimpleAttributeDefinition simpleAttributeDefinition : METRICS) {
                registry.registerMetric((AttributeDefinition)simpleAttributeDefinition, (OperationStepHandler)QueueReadAttributeHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            QueueControlHandler.INSTANCE.registerOperations(registry);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    static boolean forwardToRuntimeQueue(OperationContext context, ModelNode operation, OperationStepHandler handler) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String queueName = address.getLastElement().getValue();
        PathAddress hornetQPathAddress = MessagingServices.getHornetQServerPathAddress(address);
        Resource hornetqServerResource = context.readResourceFromRoot(hornetQPathAddress);
        boolean hasChild = hornetqServerResource.hasChild(address.getLastElement());
        if (hasChild) {
            return false;
        }
        ModelNode forwardOperation = operation.clone();
        forwardOperation.get("address").set(hornetQPathAddress.append("runtime-queue", queueName).toModelNode());
        context.addStep(forwardOperation, handler, OperationContext.Stage.RUNTIME, true);
        return true;
    }
}

