/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.ConnectorServiceParamDefinition;
import org.jboss.as.messaging.CoreAddressDefinition;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.HornetQServerResourceDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.ServletConnectorDefinition;
import org.jboss.as.messaging.TransportParamDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.dmr.ModelNode;

public class MessagingTransformers {
    static void registerTransformers(SubsystemRegistration subsystem) {
        MessagingTransformers.registerTransformers_1_1_0(subsystem);
        MessagingTransformers.registerTransformers_1_2_0(subsystem);
        MessagingTransformers.registerTransformers_1_2_1(subsystem);
        MessagingTransformers.registerTransformers_1_3_0(subsystem);
    }

    private static void registerTransformers_1_1_0(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder transport;
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        subsystemRoot.rejectChildResource(JMSBridgeDefinition.PATH);
        subsystemRoot.rejectChildResource(CoreAddressDefinition.PATH);
        subsystemRoot.rejectChildResource(PathElement.pathElement((String)"runtime-queue"));
        ResourceTransformationDescriptionBuilder hornetqServer = ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemRoot.addChildResource(PathElement.pathElement((String)"hornetq-server")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, HornetQServerResourceDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.DEFINED, HornetQServerResourceDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).setDiscard(DiscardAttributeChecker.UNDEFINED, HornetQServerResourceDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)CommonAttributes.ID_CACHE_SIZE.getDefaultValue(), (boolean)true), new AttributeDefinition[]{CommonAttributes.ID_CACHE_SIZE})).end();
        for (String path : MessagingPathHandlers.PATHS.keySet()) {
            ((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(PathElement.pathElement((String)"path", (String)path)).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new String[]{"path"})).end();
        }
        for (String path : new String[]{"in-vm-acceptor", "in-vm-connector"}) {
            transport = ((OperationTransformationOverrideBuilder)((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(PathElement.pathElement((String)path)).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, InVMTransportDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end().addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new String[]{"param"})).end();
            ((AttributeTransformationDescriptionBuilder)transport.addChildResource(TransportParamDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, TransportParamDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        }
        for (String path : new String[]{"remote-acceptor", "remote-connector", "acceptor", "connector"}) {
            transport = ((OperationTransformationOverrideBuilder)hornetqServer.addChildResource(PathElement.pathElement((String)path)).addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new String[]{"param"})).end();
            ((AttributeTransformationDescriptionBuilder)transport.addChildResource(TransportParamDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, TransportParamDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        }
        hornetqServer.rejectChildResource(ServletConnectorDefinition.PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(BroadcastGroupDefinition.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, BroadcastGroupDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.DEFINED, BroadcastGroupDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, BroadcastGroupDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(DiscoveryGroupDefinition.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, DiscoveryGroupDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.DEFINED, DiscoveryGroupDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, DiscoveryGroupDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(DivertDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, DivertDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(QueueDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, QueueDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(BridgeDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, BridgeDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(ClusterConnectionDefinition.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, ClusterConnectionDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.DEFINED, ClusterConnectionDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, ClusterConnectionDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(GroupingHandlerDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, GroupingHandlerDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(AddressSettingDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, AddressSettingDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ResourceTransformationDescriptionBuilder connectorService = hornetqServer.addChildResource(ConnectorServiceDefinition.PATH);
        ((AttributeTransformationDescriptionBuilder)connectorService.addChildResource(ConnectorServiceParamDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, ConnectorServiceParamDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(ConnectionFactoryDefinition.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, ConnectionFactoryDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.DEFINED, ConnectionFactoryDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, ConnectionFactoryDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(PooledConnectionFactoryDefinition.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, PooledConnectionFactoryDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.DEFINED, PooledConnectionFactoryDefinition.ATTRIBUTES_ADDED_IN_1_2_0)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, PooledConnectionFactoryDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS.getDefaultValue(), (boolean)true), new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS})).end();
        ((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(JMSQueueDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, JMSQueueDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        ((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(JMSTopicDefinition.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, JMSTopicDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0)).end();
        TransformationDescription.Tools.register((TransformationDescription)subsystemRoot.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)MessagingExtension.VERSION_1_1_0);
    }

    private static void registerTransformers_1_2_0(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder hornetqServer = subsystemRoot.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        ((AttributeTransformationDescriptionBuilder)hornetqServer.getAttributeBuilder().setDiscard(new DiscardAttributeChecker(){

            public boolean isDiscardExpressions() {
                return false;
            }

            public boolean isDiscardUndefined() {
                return true;
            }

            public boolean isOperationParameterDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
                Set clusterConnectionNames = context.readResource(PathAddress.EMPTY_ADDRESS).getChildrenNames(ClusterConnectionDefinition.PATH.getKey());
                boolean clustered = !clusterConnectionNames.isEmpty();
                boolean wantsClustered = attributeValue.asBoolean(clustered);
                if (clustered && !wantsClustered) {
                    PathAddress serverAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
                    String msg = MessagingMessages.MESSAGES.canNotChangeClusteredAttribute(serverAddress);
                    context.getLogger().logAttributeWarning(serverAddress, operation, msg, CommonAttributes.CLUSTERED.getName());
                }
                return true;
            }

            public boolean isResourceAttributeDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return true;
            }
        }, new AttributeDefinition[]{CommonAttributes.CLUSTERED})).end();
        hornetqServer.rejectChildResource(ServletConnectorDefinition.PATH);
        TransformationDescription.Tools.register((TransformationDescription)subsystemRoot.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)MessagingExtension.VERSION_1_2_0);
    }

    private static void registerTransformers_1_2_1(SubsystemRegistration subsystem) {
        TransformationDescription.Tools.register((TransformationDescription)MessagingTransformers.get1_2_1_1_3_0Description(), (SubsystemRegistration)subsystem, (ModelVersionRange)MessagingExtension.VERSION_1_2_1);
    }

    private static void registerTransformers_1_3_0(SubsystemRegistration subsystem) {
        TransformationDescription.Tools.register((TransformationDescription)MessagingTransformers.get1_2_1_1_3_0Description(), (SubsystemRegistration)subsystem, (ModelVersionRange)MessagingExtension.VERSION_1_3_0);
    }

    private static TransformationDescription get1_2_1_1_3_0Description() {
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder hornetqServer = subsystemRoot.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(BridgeDefinition.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, BridgeDefinition.ATTRIBUTES_ADDED_IN_2_0_0)).addRejectCheck(RejectAttributeChecker.DEFINED, BridgeDefinition.ATTRIBUTES_ADDED_IN_2_0_0)).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hornetqServer.addChildResource(AddressSettingDefinition.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, (AttributeDefinition[])AddressSettingDefinition.ATTRIBUTES_ADDED_IN_2_0_0)).addRejectCheck(RejectAttributeChecker.DEFINED, (AttributeDefinition[])AddressSettingDefinition.ATTRIBUTES_ADDED_IN_2_0_0)).end();
        hornetqServer.rejectChildResource(ServletConnectorDefinition.PATH);
        return subsystemRoot.build();
    }
}

