/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.io.File;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.netty.channel.socket.http.HttpTunnelingServlet;

class ServletConnectorService
implements Service<Void> {
    private final String hornetqServerName;
    private final String connectorName;
    private InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<WebHost> injectedVirtualHost = new InjectedValue();
    private WebDeploymentController controller;

    static ServiceName getServiceName(String hornetqServerName, String connectorName) {
        return MessagingServices.getHornetQServiceName(hornetqServerName).append(new String[]{"servlet-connector", connectorName});
    }

    private static String getContextRoot() {
        return "/hornetq-server";
    }

    private static String getUrlMapping(String hornetqServerName, String connectorName) {
        return "/" + hornetqServerName + "/" + connectorName;
    }

    static String getServletPath(String hornetqServerName, String connectorName) {
        return ServletConnectorService.getContextRoot() + ServletConnectorService.getUrlMapping(hornetqServerName, connectorName);
    }

    static String getServletEndpoint(String hornetqServerName, String connectorName) {
        return "org.hornetq." + hornetqServerName + "." + connectorName;
    }

    static ServiceController<Void> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler, String host, String hornetqServerName, String connectorName) {
        ServiceName hornetQServiceName = MessagingServices.getHornetQServiceName(hornetqServerName);
        ServiceName serviceName = ServletConnectorService.getServiceName(hornetqServerName, connectorName);
        ServletConnectorService service = new ServletConnectorService(hornetqServerName, connectorName);
        return serviceTarget.addService(serviceName, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment).addDependency(WebHost.SERVICE_NAME.append(new String[]{host}), WebHost.class, service.injectedVirtualHost).addDependency(HornetQActivationService.getHornetQActivationServiceName(hornetQServiceName)).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    ServletConnectorService(String hornetqServerName, String connectorName) {
        this.hornetqServerName = hornetqServerName;
        this.connectorName = connectorName;
        if (hornetqServerName == null) {
            throw MessagingMessages.MESSAGES.nullVar("hornetqServerName");
        }
        if (connectorName == null) {
            throw MessagingMessages.MESSAGES.nullVar("connectorName");
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            WebDeploymentBuilder deployment = this.createWebDeployment(this.hornetqServerName, this.connectorName);
            this.controller = ((WebHost)this.injectedVirtualHost.getValue()).addWebDeployment(deployment);
            this.controller.create();
            this.controller.start();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            this.controller.stop();
            this.controller.destroy();
        }
        catch (Exception e) {
            MessagingLogger.MESSAGING_LOGGER.failedToDestroy(e, "web deployment", this.controller.toString());
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    private WebDeploymentBuilder createWebDeployment(String hornetqServerName, String connectorName) throws Exception {
        WebDeploymentBuilder builder = new WebDeploymentBuilder();
        builder.setContextRoot(ServletConnectorService.getContextRoot());
        File documentRoot = new File(((ServerEnvironment)this.injectedServerEnvironment.getValue()).getServerTempDir() + File.separator + hornetqServerName + File.separator + connectorName + "-root");
        builder.setDocumentRoot(documentRoot);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        builder.setClassLoader(classLoader);
        ServletBuilder servlet = new ServletBuilder();
        servlet.setServletName(hornetqServerName + "-" + connectorName);
        servlet.setServletClass(classLoader.loadClass(HttpTunnelingServlet.class.getName()));
        servlet.addUrlMapping(ServletConnectorService.getUrlMapping(hornetqServerName, connectorName));
        servlet.addInitParam("endpoint", "local:" + ServletConnectorService.getServletEndpoint(hornetqServerName, connectorName));
        servlet.setForceInit(true);
        builder.addServlet(servlet);
        return builder;
    }
}

