/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.connector.metadata.common.CredentialImpl;
import org.jboss.as.connector.metadata.common.SecurityImpl;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterActivatorService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Activationspec;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.CredentialInterfaceEnum;
import org.jboss.jca.common.api.metadata.spec.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.Messageadapter;
import org.jboss.jca.common.api.metadata.spec.OutboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.PoolImpl;
import org.jboss.jca.common.metadata.common.TimeOutImpl;
import org.jboss.jca.common.metadata.common.ValidationImpl;
import org.jboss.jca.common.metadata.common.XaPoolImpl;
import org.jboss.jca.common.metadata.resourceadapter.ActivationImpl;
import org.jboss.jca.common.metadata.spec.ActivationSpecImpl;
import org.jboss.jca.common.metadata.spec.AuthenticationMechanismImpl;
import org.jboss.jca.common.metadata.spec.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.spec.ConnectorImpl;
import org.jboss.jca.common.metadata.spec.InboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.MessageAdapterImpl;
import org.jboss.jca.common.metadata.spec.MessageListenerImpl;
import org.jboss.jca.common.metadata.spec.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.RequiredConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ResourceAdapterImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.broadcast.CommandDispatcherBroadcastEndpointFactory;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigProperties;
import org.wildfly.extension.messaging.activemq.jms.WildFlyRecoveryRegistry;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public class PooledConnectionFactoryService
implements Service<Void> {
    private static final List<LocalizedXsdString> EMPTY_LOCL = Collections.emptyList();
    public static final String CONNECTOR_CLASSNAME = "connectorClassName";
    public static final String CONNECTION_PARAMETERS = "connectionParameters";
    private static final String ACTIVEMQ_ACTIVATION = "org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec";
    private static final String ACTIVEMQ_CONN_DEF = "ActiveMQConnectionDefinition";
    private static final String ACTIVEMQ_RESOURCE_ADAPTER = "org.wildfly.extension.messaging.activemq.ActiveMQResourceAdapter";
    private static final String RAMANAGED_CONN_FACTORY = "org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory";
    private static final String RA_CONN_FACTORY = "org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory";
    private static final String RA_CONN_FACTORY_IMPL = "org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl";
    private static final String JMS_SESSION = "jakarta.jms.Session";
    private static final String ACTIVEMQ_RA_SESSION = "org.apache.activemq.artemis.ra.ActiveMQRASession";
    private static final String BASIC_PASS = "BasicPassword";
    private static final String JMS_QUEUE = "jakarta.jms.Queue";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String LONG_TYPE = "java.lang.Long";
    private static final String SESSION_DEFAULT_TYPE = "SessionDefaultType";
    private static final String TRY_LOCK = "UseTryLock";
    private static final String JMS_MESSAGE_LISTENER = "jakarta.jms.MessageListener";
    private static final String DEFAULT_MAX_RECONNECTS = "5";
    public static final String GROUP_ADDRESS = "discoveryAddress";
    public static final String DISCOVERY_INITIAL_WAIT_TIMEOUT = "discoveryInitialWaitTimeout";
    public static final String GROUP_PORT = "discoveryPort";
    public static final String REFRESH_TIMEOUT = "discoveryRefreshTimeout";
    public static final String DISCOVERY_LOCAL_BIND_ADDRESS = "discoveryLocalBindAddress";
    public static final String JGROUPS_CHANNEL_LOCATOR_CLASS = "jgroupsChannelLocatorClass";
    public static final String JGROUPS_CHANNEL_NAME = "jgroupsChannelName";
    public static final String JGROUPS_CHANNEL_REF_NAME = "jgroupsChannelRefName";
    public static final String IGNORE_JTA = "ignoreJTA";
    private List<String> connectors;
    private String discoveryGroupName;
    private List<PooledConnectionFactoryConfigProperties> adapterParams;
    private String name;
    private Map<String, SocketBinding> socketBindings = new HashMap<String, SocketBinding>();
    private InjectedValue<ActiveMQBroker> activeMQBroker = new InjectedValue();
    private ContextNames.BindInfo bindInfo;
    private List<String> jndiAliases;
    private final boolean pickAnyConnectors;
    private String txSupport;
    private int minPoolSize;
    private int maxPoolSize;
    private String serverName;
    private final String jgroupsChannelName;
    private final boolean createBinderService;
    private final String managedConnectionPoolClassName;
    private final Boolean enlistmentTrace;
    private InjectedValue<ExceptionSupplier<CredentialSource, Exception>> credentialSourceSupplier = new InjectedValue();

    public PooledConnectionFactoryService(String name, List<String> connectors, String discoveryGroupName, String serverName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, List<String> jndiAliases, String txSupport, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace) {
        this.name = name;
        this.connectors = connectors;
        this.discoveryGroupName = discoveryGroupName;
        this.serverName = serverName;
        this.jgroupsChannelName = jgroupsChannelName;
        this.adapterParams = adapterParams;
        this.bindInfo = bindInfo;
        this.jndiAliases = new ArrayList<String>(jndiAliases);
        this.createBinderService = true;
        this.txSupport = txSupport;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.managedConnectionPoolClassName = managedConnectionPoolClassName;
        this.enlistmentTrace = enlistmentTrace;
        this.pickAnyConnectors = false;
    }

    public PooledConnectionFactoryService(String name, List<String> connectors, String discoveryGroupName, String serverName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, String txSupport, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace, boolean pickAnyConnectors) {
        this.name = name;
        this.connectors = connectors;
        this.discoveryGroupName = discoveryGroupName;
        this.serverName = serverName;
        this.jgroupsChannelName = jgroupsChannelName;
        this.adapterParams = adapterParams;
        this.bindInfo = bindInfo;
        this.jndiAliases = Collections.emptyList();
        this.createBinderService = false;
        this.txSupport = txSupport;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.managedConnectionPoolClassName = managedConnectionPoolClassName;
        this.enlistmentTrace = enlistmentTrace;
        this.pickAnyConnectors = pickAnyConnectors;
    }

    static ServiceName getResourceAdapterActivatorsServiceName(String name) {
        return ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE.append(new String[]{name});
    }

    InjectedValue<ExceptionSupplier<CredentialSource, Exception>> getCredentialSourceSupplierInjector() {
        return this.credentialSourceSupplier;
    }

    public static PooledConnectionFactoryService installService(ServiceTarget serviceTarget, String name, String serverName, List<String> connectors, String discoveryGroupName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, String txSupport, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace, boolean pickAnyConnectors) {
        ServiceName serverServiceName = MessagingServices.getActiveMQServiceName(serverName);
        ServiceName serviceName = JMSServices.getPooledConnectionFactoryBaseServiceName(serverServiceName).append(new String[]{name});
        PooledConnectionFactoryService service = new PooledConnectionFactoryService(name, connectors, discoveryGroupName, serverName, jgroupsChannelName, adapterParams, bindInfo, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, pickAnyConnectors);
        PooledConnectionFactoryService.installService0(serviceTarget, serverServiceName, serviceName, service);
        return service;
    }

    public static PooledConnectionFactoryService installService(OperationContext context, String name, String serverName, List<String> connectors, String discoveryGroupName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, List<String> jndiAliases, String txSupport, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace, ModelNode model) throws OperationFailedException {
        ServiceName serverServiceName = MessagingServices.getActiveMQServiceName(serverName);
        ServiceName serviceName = JMSServices.getPooledConnectionFactoryBaseServiceName(serverServiceName).append(new String[]{name});
        PooledConnectionFactoryService service = new PooledConnectionFactoryService(name, connectors, discoveryGroupName, serverName, jgroupsChannelName, adapterParams, bindInfo, jndiAliases, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace);
        PooledConnectionFactoryService.installService0(context, serverServiceName, serviceName, service, model);
        return service;
    }

    private static void installService0(ServiceTarget serviceTarget, ServiceName serverServiceName, ServiceName serviceName, PooledConnectionFactoryService service) {
        ServiceBuilder serviceBuilder = PooledConnectionFactoryService.createServiceBuilder(serviceTarget, serverServiceName, serviceName, service);
        serviceBuilder.install();
    }

    private static void installService0(OperationContext context, ServiceName serverServiceName, ServiceName serviceName, PooledConnectionFactoryService service, ModelNode model) throws OperationFailedException {
        ServiceBuilder serviceBuilder = PooledConnectionFactoryService.createServiceBuilder(context.getServiceTarget(), serverServiceName, serviceName, service);
        ModelNode credentialReference = ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE.resolveModelAttribute(context, model);
        if (credentialReference.isDefined()) {
            service.getCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)serviceBuilder));
        }
        serviceBuilder.install();
    }

    private static ServiceBuilder createServiceBuilder(ServiceTarget serviceTarget, ServiceName serverServiceName, ServiceName serviceName, PooledConnectionFactoryService service) {
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        serviceBuilder.requires(MessagingServices.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider", new String[0]));
        serviceBuilder.addDependency(serverServiceName, ActiveMQBroker.class, service.activeMQBroker);
        serviceBuilder.requires(ActiveMQActivationService.getServiceName(serverServiceName));
        serviceBuilder.requires(JMSServices.getJmsManagerBaseServiceName(serverServiceName));
        serviceBuilder.requires(MessagingServices.ACTIVEMQ_CLIENT_THREAD_POOL);
        serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE);
        return serviceBuilder;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void start(StartContext context) throws StartException {
        ServiceTarget serviceTarget = context.getChildTarget();
        try {
            this.createService(serviceTarget, context.getController().getServiceContainer());
        }
        catch (Exception e) {
            throw MessagingLogger.ROOT_LOGGER.failedToCreate(e, "resource adapter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createService(ServiceTarget serviceTarget, ServiceContainer container) throws Exception {
        InputStream is = null;
        InputStream isIj = null;
        ArrayList<ConfigProperty> properties = new ArrayList<ConfigProperty>();
        try {
            Object connectorNames;
            StringBuilder connectorClassname = new StringBuilder();
            StringBuilder connectorParams = new StringBuilder();
            if (this.discoveryGroupName == null && this.connectors.isEmpty() && this.pickAnyConnectors && !(connectorNames = ((ActiveMQServer)ActiveMQServer.class.cast(((ActiveMQBroker)this.activeMQBroker.getValue()).getDelegate())).getConfiguration().getConnectorConfigurations().keySet()).isEmpty()) {
                String connectorName = (String)connectorNames.iterator().next();
                MessagingLogger.ROOT_LOGGER.connectorForPooledConnectionFactory(this.name, connectorName);
                this.connectors.add(connectorName);
            }
            for (String connector : this.connectors) {
                TransportConfiguration tc = (TransportConfiguration)((ActiveMQServer)ActiveMQServer.class.cast(((ActiveMQBroker)this.activeMQBroker.getValue()).getDelegate())).getConfiguration().getConnectorConfigurations().get(connector);
                if (tc == null) {
                    throw MessagingLogger.ROOT_LOGGER.connectorNotDefined(connector);
                }
                if (connectorClassname.length() > 0) {
                    connectorClassname.append(",");
                    connectorParams.append(",");
                }
                connectorClassname.append(tc.getFactoryClassName());
                Map params = tc.getParams();
                boolean multiple = false;
                for (Map.Entry entry : params.entrySet()) {
                    if (multiple) {
                        connectorParams.append(";");
                    }
                    connectorParams.append((String)entry.getKey()).append("=").append(entry.getValue());
                    multiple = true;
                }
            }
            if (connectorClassname.length() > 0) {
                properties.add(PooledConnectionFactoryService.simpleProperty15(CONNECTOR_CLASSNAME, STRING_TYPE, connectorClassname.toString()));
            }
            if (connectorParams.length() > 0) {
                properties.add(PooledConnectionFactoryService.simpleProperty15(CONNECTION_PARAMETERS, STRING_TYPE, connectorParams.toString()));
            }
            if (this.discoveryGroupName != null) {
                DiscoveryGroupConfiguration discoveryGroupConfiguration = (DiscoveryGroupConfiguration)((ActiveMQServer)ActiveMQServer.class.cast(((ActiveMQBroker)this.activeMQBroker.getValue()).getDelegate())).getConfiguration().getDiscoveryGroupConfigurations().get(this.discoveryGroupName);
                BroadcastEndpointFactory bgCfg = discoveryGroupConfiguration.getBroadcastEndpointFactory();
                if (bgCfg instanceof UDPBroadcastEndpointFactory) {
                    UDPBroadcastEndpointFactory udpCfg = (UDPBroadcastEndpointFactory)bgCfg;
                    properties.add(PooledConnectionFactoryService.simpleProperty15(GROUP_ADDRESS, STRING_TYPE, udpCfg.getGroupAddress()));
                    properties.add(PooledConnectionFactoryService.simpleProperty15(GROUP_PORT, INTEGER_TYPE, "" + udpCfg.getGroupPort()));
                    properties.add(PooledConnectionFactoryService.simpleProperty15(DISCOVERY_LOCAL_BIND_ADDRESS, STRING_TYPE, udpCfg.getLocalBindAddress()));
                } else if (bgCfg instanceof CommandDispatcherBroadcastEndpointFactory) {
                    properties.add(PooledConnectionFactoryService.simpleProperty15(JGROUPS_CHANNEL_NAME, STRING_TYPE, this.jgroupsChannelName));
                    properties.add(PooledConnectionFactoryService.simpleProperty15(JGROUPS_CHANNEL_REF_NAME, STRING_TYPE, this.serverName + "/discovery" + discoveryGroupConfiguration.getName()));
                }
                properties.add(PooledConnectionFactoryService.simpleProperty15(DISCOVERY_INITIAL_WAIT_TIMEOUT, LONG_TYPE, "" + discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout()));
                properties.add(PooledConnectionFactoryService.simpleProperty15(REFRESH_TIMEOUT, LONG_TYPE, "" + discoveryGroupConfiguration.getRefreshTimeout()));
            }
            boolean hasReconnect = false;
            ArrayList<ConfigProperty> inboundProperties = new ArrayList<ConfigProperty>();
            ArrayList<ConfigProperty> outboundProperties = new ArrayList<ConfigProperty>();
            String reconnectName = "reconnectAttempts";
            block9: for (PooledConnectionFactoryConfigProperties adapterParam : this.adapterParams) {
                hasReconnect |= "reconnectAttempts".equals(adapterParam.getName());
                ConfigProperty p = PooledConnectionFactoryService.simpleProperty15(adapterParam.getName(), adapterParam.getType(), adapterParam.getValue());
                if (adapterParam.getName().equals("rebalanceConnections")) {
                    boolean rebalanceConnections = Boolean.parseBoolean(adapterParam.getValue());
                    if (!rebalanceConnections) continue;
                    inboundProperties.add(p);
                    continue;
                }
                if (null == adapterParam.getConfigType()) {
                    properties.add(p);
                    continue;
                }
                switch (adapterParam.getConfigType()) {
                    case INBOUND: {
                        inboundProperties.add(p);
                        continue block9;
                    }
                    case OUTBOUND: {
                        outboundProperties.add(p);
                        continue block9;
                    }
                }
                properties.add(p);
            }
            if (!hasReconnect) {
                properties.add(PooledConnectionFactoryService.simpleProperty15("reconnectAttempts", Integer.class.getName(), DEFAULT_MAX_RECONNECTS));
            }
            this.configureCredential(properties);
            inboundProperties.add(PooledConnectionFactoryService.simpleProperty15("queuePrefix", String.class.getName(), "jms.queue."));
            inboundProperties.add(PooledConnectionFactoryService.simpleProperty15("topicPrefix", String.class.getName(), "jms.topic."));
            OutboundResourceAdapter outbound = PooledConnectionFactoryService.createOutbound(outboundProperties);
            InboundResourceAdapter inbound = this.createInbound(inboundProperties);
            ResourceAdapter ra = this.createResourceAdapter15(properties, outbound, inbound);
            Connector cmd = PooledConnectionFactoryService.createConnector15(ra);
            TransactionSupportEnum transactionSupport = PooledConnectionFactoryService.getTransactionSupport(this.txSupport);
            ConnectionDefinition common = PooledConnectionFactoryService.createConnDef(transactionSupport, this.bindInfo.getBindName(), this.minPoolSize, this.maxPoolSize, this.managedConnectionPoolClassName, this.enlistmentTrace);
            Activation activation = PooledConnectionFactoryService.createActivation(common, transactionSupport);
            ResourceAdapterActivatorService activator = new ResourceAdapterActivatorService(cmd, activation, PooledConnectionFactoryService.class.getClassLoader(), this.name);
            activator.setBindInfo(this.bindInfo);
            activator.setCreateBinderService(this.createBinderService);
            activator.addJndiAliases(this.jndiAliases);
            ServiceBuilder sb = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(PooledConnectionFactoryService.getResourceAdapterActivatorsServiceName(this.name), (Service)activator), (Injector)activator.getExecutorServiceInjector()).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, activator.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, activator.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, activator.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, activator.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, activator.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, activator.getConfigInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, activator.getCcmInjector());
            sb.requires(ActiveMQActivationService.getServiceName(MessagingServices.getActiveMQServiceName(this.serverName)));
            sb.requires(NamingService.SERVICE_NAME);
            sb.requires(MessagingServices.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider", new String[0]));
            WildFlyRecoveryRegistry.supplier = sb.requires(MessagingServices.getCapabilityServiceName("org.wildfly.transactions.xa-resource-recovery-registry", new String[0]));
            sb.requires(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"}));
            sb.setInitialMode(ServiceController.Mode.PASSIVE).install();
            serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{this.name}), Service.NULL).install();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (isIj != null) {
                isIj.close();
            }
        }
    }

    private void configureCredential(List<ConfigProperty> properties) {
        if (this.credentialSourceSupplier.getOptionalValue() != null) {
            try {
                char[] password;
                CredentialSource credentialSource = (CredentialSource)((ExceptionSupplier)this.credentialSourceSupplier.getValue()).get();
                if (credentialSource != null && (password = ((ClearPassword)((PasswordCredential)credentialSource.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword()) != null) {
                    properties.add(PooledConnectionFactoryService.simpleProperty15("password", String.class.getName(), new String(password)));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static TransactionSupportEnum getTransactionSupport(String txSupport) {
        try {
            return TransactionSupportEnum.valueOf((String)txSupport);
        }
        catch (RuntimeException e) {
            return TransactionSupportEnum.LocalTransaction;
        }
    }

    private static Activation createActivation(ConnectionDefinition common, TransactionSupportEnum transactionSupport) {
        List<ConnectionDefinition> definitions = Collections.singletonList(common);
        boolean ignoreJTA = transactionSupport == TransactionSupportEnum.NoTransaction;
        Map configProperties = ignoreJTA ? Collections.singletonMap(IGNORE_JTA, String.valueOf(ignoreJTA)) : Collections.emptyMap();
        return new ActivationImpl(null, null, transactionSupport, definitions, Collections.emptyList(), configProperties, Collections.emptyList(), null, null);
    }

    private static ConnectionDefinition createConnDef(TransactionSupportEnum transactionSupport, String jndiName, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace) throws ValidateException {
        PoolImpl pool;
        Integer minSize = minPoolSize == -1 ? null : Integer.valueOf(minPoolSize);
        Integer maxSize = maxPoolSize == -1 ? null : Integer.valueOf(maxPoolSize);
        boolean prefill = false;
        boolean useStrictMin = false;
        FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
        Boolean isXA = Boolean.FALSE;
        if (transactionSupport == TransactionSupportEnum.XATransaction) {
            pool = new XaPoolImpl(minSize, Defaults.INITIAL_POOL_SIZE, maxSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, null, Defaults.FAIR, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL);
            isXA = Boolean.TRUE;
        } else {
            pool = new PoolImpl(minSize, Defaults.INITIAL_POOL_SIZE, maxSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, null, Defaults.FAIR);
        }
        TimeOutImpl timeOut = new TimeOutImpl(null, null, null, null, null){};
        SecurityImpl security = new SecurityImpl(null, null, true);
        Recovery recovery = new Recovery((Credential)new CredentialImpl(null, null, null, null), null, Boolean.TRUE);
        ValidationImpl validation = new ValidationImpl(Defaults.VALIDATE_ON_MATCH, null, null, Boolean.valueOf(false));
        return new org.jboss.jca.common.metadata.resourceadapter.ConnectionDefinitionImpl(Collections.emptyMap(), RAMANAGED_CONN_FACTORY, jndiName, ACTIVEMQ_CONN_DEF, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Defaults.SHARABLE, Defaults.ENLISTMENT, Defaults.CONNECTABLE, Boolean.valueOf(false), managedConnectionPoolClassName, enlistmentTrace, (Pool)pool, (TimeOut)timeOut, (Validation)validation, (Security)security, recovery, isXA);
    }

    private static Connector createConnector15(ResourceAdapter ra) {
        return new ConnectorImpl(Connector.Version.V_15, null, PooledConnectionFactoryService.str("Red Hat"), PooledConnectionFactoryService.str("JMS 1.1 Server"), PooledConnectionFactoryService.str("1.0"), null, ra, null, false, EMPTY_LOCL, EMPTY_LOCL, Collections.emptyList(), null);
    }

    private ResourceAdapter createResourceAdapter15(List<ConfigProperty> properties, OutboundResourceAdapter outbound, InboundResourceAdapter inbound) {
        return new ResourceAdapterImpl(PooledConnectionFactoryService.str(ACTIVEMQ_RESOURCE_ADAPTER), properties, outbound, inbound, Collections.emptyList(), Collections.emptyList(), null);
    }

    private InboundResourceAdapter createInbound(List<ConfigProperty> inboundProps) {
        List<RequiredConfigPropertyImpl> destination = Collections.singletonList(new RequiredConfigPropertyImpl(EMPTY_LOCL, PooledConnectionFactoryService.str("destination"), null));
        ActivationSpecImpl activation15 = new ActivationSpecImpl(PooledConnectionFactoryService.str(ACTIVEMQ_ACTIVATION), destination, inboundProps, null);
        List<MessageListenerImpl> messageListeners = Collections.singletonList(new MessageListenerImpl(PooledConnectionFactoryService.str(JMS_MESSAGE_LISTENER), (Activationspec)activation15, null));
        MessageAdapterImpl message = new MessageAdapterImpl(messageListeners, null);
        return new InboundResourceAdapterImpl((Messageadapter)message, null);
    }

    private static OutboundResourceAdapter createOutbound(List<ConfigProperty> outboundProperties) {
        ArrayList<ConnectionDefinitionImpl> definitions = new ArrayList<ConnectionDefinitionImpl>();
        ArrayList<ConfigProperty> props = new ArrayList<ConfigProperty>(outboundProperties);
        props.add(PooledConnectionFactoryService.simpleProperty15(SESSION_DEFAULT_TYPE, STRING_TYPE, JMS_QUEUE));
        props.add(PooledConnectionFactoryService.simpleProperty15(TRY_LOCK, INTEGER_TYPE, "0"));
        definitions.add(new ConnectionDefinitionImpl(PooledConnectionFactoryService.str(RAMANAGED_CONN_FACTORY), props, PooledConnectionFactoryService.str(RA_CONN_FACTORY), PooledConnectionFactoryService.str(RA_CONN_FACTORY_IMPL), PooledConnectionFactoryService.str(JMS_SESSION), PooledConnectionFactoryService.str(ACTIVEMQ_RA_SESSION), null));
        AuthenticationMechanismImpl basicPassword = new AuthenticationMechanismImpl(Collections.emptyList(), PooledConnectionFactoryService.str(BASIC_PASS), CredentialInterfaceEnum.PasswordCredential, null, null);
        return new OutboundResourceAdapterImpl(definitions, TransactionSupportEnum.XATransaction, Collections.singletonList(basicPassword), false, null, null, null);
    }

    private static XsdString str(String str) {
        return new XsdString(str, null);
    }

    private static ConfigProperty simpleProperty15(String name, String type, String value) {
        return new ConfigPropertyImpl(EMPTY_LOCL, PooledConnectionFactoryService.str(name), PooledConnectionFactoryService.str(type), PooledConnectionFactoryService.str(value), null, null, null, null, false, null, null, null, null);
    }

    public void stop(StopContext context) {
    }
}

