/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.ManagementUtil;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.OperationDefinitionHelper;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class JMSServerControlHandler
extends AbstractRuntimeOnlyHandler {
    private static final AttributeDefinition ADDRESS_NAME = OperationDefinitionHelper.createNonEmptyStringAttribute("address-name");
    private static final AttributeDefinition SESSION_ID = OperationDefinitionHelper.createNonEmptyStringAttribute("session-id");
    private static final AttributeDefinition CONNECTION_ID = OperationDefinitionHelper.createNonEmptyStringAttribute("connection-id");
    public static final String LIST_CONNECTIONS_AS_JSON = "list-connections-as-json";
    public static final String LIST_CONSUMERS_AS_JSON = "list-consumers-as-json";
    public static final String LIST_ALL_CONSUMERS_AS_JSON = "list-all-consumers-as-json";
    public static final String LIST_TARGET_DESTINATIONS = "list-target-destinations";
    public static final String GET_LAST_SENT_MESSAGE_ID = "get-last-sent-message-id";
    public static final String GET_SESSION_CREATION_TIME = "get-session-creation-time";
    public static final String LIST_SESSIONS_AS_JSON = "list-sessions-as-json";
    public static final String LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON = "list-prepared-transaction-jms-details-as-json";
    public static final String LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML = "list-prepared-transaction-jms-details-as-html";
    public static final JMSServerControlHandler INSTANCE = new JMSServerControlHandler();

    private JMSServerControlHandler() {
    }

    public JsonObject enrich(JsonObject source, String key, String value) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add(key, value);
        source.entrySet().forEach(e -> builder.add((String)e.getKey(), (JsonValue)e.getValue()));
        return builder.build();
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block38: {
            if (ActiveMQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
                return;
            }
            String operationName = operation.require("operation").asString();
            ActiveMQBroker server = this.getServer(context, operation);
            if (server == null) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
            }
            ActiveMQServerControl serverControl = server.getActiveMQServerControl();
            try {
                if (LIST_CONNECTIONS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listConnectionsAsJSON();
                    context.getResult().set(json);
                    JsonArrayBuilder enrichedConnections = Json.createArrayBuilder();
                    try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
                        JsonArray connections = reader.readArray();
                        for (int i = 0; i < connections.size(); ++i) {
                            JsonObject originalConnection = connections.getJsonObject(i);
                            JsonObject enrichedConnection = this.enrichConnection(originalConnection, serverControl);
                            enrichedConnections.add((JsonValue)enrichedConnection);
                        }
                    }
                    String enrichedJSON = enrichedConnections.build().toString();
                    context.getResult().set(enrichedJSON);
                    break block38;
                }
                if (LIST_CONSUMERS_AS_JSON.equals(operationName)) {
                    String connectionID = CONNECTION_ID.resolveModelAttribute(context, operation).asString();
                    String json = serverControl.listConsumersAsJSON(connectionID);
                    JsonArrayBuilder enrichedConsumers = Json.createArrayBuilder();
                    try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
                        JsonArray consumers = reader.readArray();
                        for (int i = 0; i < consumers.size(); ++i) {
                            JsonObject originalConsumer = consumers.getJsonObject(i);
                            JsonObject enrichedConsumer = this.enrichConsumer(originalConsumer, server);
                            enrichedConsumers.add((JsonValue)enrichedConsumer);
                        }
                    }
                    String enrichedJSON = enrichedConsumers.build().toString();
                    context.getResult().set(enrichedJSON);
                    break block38;
                }
                if (LIST_ALL_CONSUMERS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listAllConsumersAsJSON();
                    JsonArrayBuilder enrichedConsumers = Json.createArrayBuilder();
                    try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
                        JsonArray consumers = reader.readArray();
                        for (int i = 0; i < consumers.size(); ++i) {
                            JsonObject originalConsumer = consumers.getJsonObject(i);
                            JsonObject enrichedConsumer = this.enrichConsumer(originalConsumer, server);
                            enrichedConsumers.add((JsonValue)enrichedConsumer);
                        }
                    }
                    String enrichedJSON = enrichedConsumers.build().toString();
                    context.getResult().set(enrichedJSON);
                    break block38;
                }
                if (LIST_TARGET_DESTINATIONS.equals(operationName)) {
                    String sessionID = SESSION_ID.resolveModelAttribute(context, operation).asString();
                    String[] list = this.listTargetDestinations(server, sessionID);
                    ManagementUtil.reportListOfStrings(context, list);
                    break block38;
                }
                if (GET_LAST_SENT_MESSAGE_ID.equals(operationName)) {
                    String sessionID = SESSION_ID.resolveModelAttribute(context, operation).asString();
                    String addressName = ADDRESS_NAME.resolveModelAttribute(context, operation).asString();
                    ServerSession session = ((ActiveMQServer)server.getDelegate()).getSessionByID(sessionID);
                    if (session == null) break block38;
                    for (ServerProducer producer : session.getServerProducers()) {
                        if (!addressName.equals(producer.getAddress())) continue;
                        context.getResult().set(producer.getLastProducedMessageID().toString());
                        break block38;
                    }
                    break block38;
                }
                if (GET_SESSION_CREATION_TIME.equals(operationName)) {
                    String sessionID = SESSION_ID.resolveModelAttribute(context, operation).asString();
                    ServerSession session = ((ActiveMQServer)server.getDelegate()).getSessionByID(sessionID);
                    if (session != null) {
                        String time = String.valueOf(session.getCreationTime());
                        context.getResult().set(time);
                    }
                    break block38;
                }
                if (LIST_SESSIONS_AS_JSON.equals(operationName)) {
                    String connectionID = CONNECTION_ID.resolveModelAttribute(context, operation).asString();
                    String json = serverControl.listSessionsAsJSON(connectionID);
                    context.getResult().set(json);
                    break block38;
                }
                if (LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listPreparedTransactionDetailsAsJSON();
                    context.getResult().set(json);
                    break block38;
                }
                if (LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML.equals(operationName)) {
                    String html = serverControl.listPreparedTransactionDetailsAsHTML();
                    context.getResult().set(html);
                    break block38;
                }
                throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        }
    }

    private JsonObject enrichConsumer(JsonObject originalConsumer, ActiveMQBroker server) {
        JsonObjectBuilder enrichedConsumer = Json.createObjectBuilder();
        for (Map.Entry entry : originalConsumer.entrySet()) {
            if ("lastProducedMessageID".equals(entry.getKey())) {
                enrichedConsumer.add("lastUUIDSent", (JsonValue)entry.getValue());
                continue;
            }
            enrichedConsumer.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        String queueName = originalConsumer.getString("queueName");
        QueueControl queueControl = (QueueControl)QueueControl.class.cast(server.getResource("queue." + queueName));
        if (queueControl == null) {
            return originalConsumer;
        }
        enrichedConsumer.add("durable", queueControl.isDurable());
        String routingType = queueControl.getRoutingType();
        String destinationType = routingType.equals("ANYCAST") ? "queue" : "topic";
        enrichedConsumer.add("destinationType", destinationType);
        String address = queueControl.getAddress();
        String destinationName = this.inferDestinationName(address);
        enrichedConsumer.add("destinationName", destinationName);
        return enrichedConsumer.build();
    }

    private JsonObject enrichConnection(JsonObject originalConnection, ActiveMQServerControl serverControl) throws Exception {
        JsonObjectBuilder enrichedConnection = Json.createObjectBuilder();
        for (Map.Entry entry : originalConnection.entrySet()) {
            enrichedConnection.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        String connectionID = originalConnection.getString("connectionID");
        String sessionsAsJSON = serverControl.listSessionsAsJSON(connectionID);
        try (JsonReader sessionsReader = Json.createReader((Reader)new StringReader(sessionsAsJSON));){
            JsonArray sessions = sessionsReader.readArray();
            for (int j = 0; j < sessions.size(); ++j) {
                JsonObject metadata;
                JsonObject session = sessions.getJsonObject(j);
                if (!session.containsKey((Object)"metadata") || !(metadata = session.getJsonObject("metadata")).containsKey((Object)"jms-client-id")) continue;
                String clientID = metadata.getString("jms-client-id");
                enrichedConnection.add("clientID", clientID);
                break;
            }
        }
        return enrichedConnection.build();
    }

    private String inferDestinationName(String address) {
        if (address.startsWith("jms.queue.")) {
            return address.substring("jms.queue.".length());
        }
        if (address.startsWith("jms.topic.")) {
            return address.substring("jms.topic.".length());
        }
        return address;
    }

    public void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_CONNECTIONS_AS_JSON, resolver).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_CONSUMERS_AS_JSON, resolver).setParameters(new AttributeDefinition[]{CONNECTION_ID}).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_ALL_CONSUMERS_AS_JSON, resolver).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_TARGET_DESTINATIONS, resolver).setParameters(new AttributeDefinition[]{SESSION_ID}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(GET_LAST_SENT_MESSAGE_ID, resolver).setParameters(new AttributeDefinition[]{SESSION_ID, ADDRESS_NAME}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(GET_SESSION_CREATION_TIME, resolver).setParameters(new AttributeDefinition[]{SESSION_ID}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_SESSIONS_AS_JSON, resolver).setParameters(new AttributeDefinition[]{CONNECTION_ID}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
    }

    private ActiveMQBroker getServer(OperationContext context, ModelNode operation) {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQBroker server = (ActiveMQBroker)ActiveMQBroker.class.cast(service.getValue());
        return server;
    }

    public String[] listTargetDestinations(ActiveMQBroker server, String sessionID) throws Exception {
        Object[] queueControls;
        ServerSession session = ((ActiveMQServer)server.getDelegate()).getSessionByID(sessionID);
        if (session == null) {
            return new String[0];
        }
        HashMap<String, QueueControl> allDests = new HashMap<String, QueueControl>();
        for (Object queue : queueControls = server.getResources(QueueControl.class)) {
            QueueControl queueControl = (QueueControl)queue;
            allDests.put(queueControl.getAddress(), queueControl);
        }
        ArrayList<String> destinations = new ArrayList<String>();
        for (ServerProducer producer : session.getServerProducers()) {
            QueueControl control = (QueueControl)allDests.get(producer.getAddress());
            if (control == null) continue;
            destinations.add(control.getAddress());
        }
        return (String[])destinations.toArray(String[]::new);
    }
}

