/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class ActiveMQActivationService
implements Service<Void> {
    public static ServiceName getServiceName(ServiceName serverName) {
        return serverName.append(new String[]{"activation"});
    }

    public static boolean isActiveMQServerActive(OperationContext context, ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        return ActiveMQActivationService.isActiveMQServerActive(context.getServiceRegistry(false), MessagingServices.getActiveMQServiceName(address));
    }

    public static boolean isActiveMQServerActive(ServiceRegistry serviceRegistry, ServiceName activeMQServerServiceName) {
        ActiveMQBroker server;
        ServiceController service = serviceRegistry.getService(activeMQServerServiceName);
        return service != null && (server = (ActiveMQBroker)ActiveMQBroker.class.cast(service.getValue())).isActive();
    }

    public static boolean rollbackOperationIfServerNotActive(OperationContext context, ModelNode operation) {
        if (ActiveMQActivationService.isActiveMQServerActive(context, operation)) {
            return false;
        }
        context.getFailureDescription().set(MessagingLogger.ROOT_LOGGER.serverInBackupMode(PathAddress.pathAddress((ModelNode)operation.require("address"))));
        context.setRollbackOnly();
        return true;
    }

    public static boolean ignoreOperationIfServerNotActive(OperationContext context, ModelNode operation) {
        if (ActiveMQActivationService.isActiveMQServerActive(context, operation)) {
            return false;
        }
        context.getResult();
        return true;
    }

    static ActiveMQServer getActiveMQServer(OperationContext context, ModelNode operation) {
        ServiceName activMQServerServiceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(false).getService(activMQServerServiceName);
        if (controller != null) {
            return (ActiveMQServer)ActiveMQServer.class.cast(((ActiveMQBroker)ActiveMQBroker.class.cast(controller.getValue())).getDelegate());
        }
        return null;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

