/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelUtil;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.util.collection.ConcurrentSet;

public class DomainControllerRuntimeIgnoreTransformationRegistry {
    public static final String MISSING_DOMAIN_RESOURCES = "missing-domain-resources";
    public static final OperationContext.AttachmentKey<NewSlaveInformation> NEW_SLAVE_INFO = OperationContext.AttachmentKey.create(NewSlaveInformation.class);
    ConcurrentMap<String, DomainControllerRuntimeIgnoreTransformationEntry> hostEntries = new ConcurrentHashMap<String, DomainControllerRuntimeIgnoreTransformationEntry>();
    ConcurrentMap<String, ConcurrentSet<PathElement>> hostKnownAddresses = new ConcurrentHashMap<String, ConcurrentSet<PathElement>>();

    public void initializeHost(String name) {
        this.hostKnownAddresses.put(name, (ConcurrentSet<PathElement>)new ConcurrentSet());
    }

    public void registerHost(String name, DomainControllerRuntimeIgnoreTransformationEntry hostEntry) {
        this.hostEntries.put(name, hostEntry);
        hostEntry.setKnownRootAddresses((ConcurrentSet<PathElement>)((ConcurrentSet)this.hostKnownAddresses.get(name)));
    }

    public void unregisterHost(String name) {
        this.hostEntries.remove(name);
        this.hostKnownAddresses.remove(name);
    }

    public void addKnownDataForSlave(String host, Set<PathElement> pathElements) {
        ((ConcurrentSet)this.hostKnownAddresses.get(host)).addAll(pathElements);
    }

    public ModelNode piggyBackMissingInformationOnHeader(OperationContext context, TransformingProxyController transformingProxyController, final String hostName, ModelNode operation) throws OperationFailedException {
        NewSlaveInformation info = this.getAttachment(context, false);
        if (info == null) {
            return operation;
        }
        Set missingResources = (Set)info.missingResources.get(hostName);
        if (missingResources == null) {
            return operation;
        }
        final ReadMasterDomainModelUtil readUtil = ReadMasterDomainModelUtil.readMasterDomainResourcesForPiggyBackFollowingDomainControllerChange(context, missingResources, transformingProxyController.getTransformers(), hostName, this);
        if (readUtil.getDescribedResources().size() > 0) {
            operation.get(new String[]{"operation-headers", MISSING_DOMAIN_RESOURCES}).set(readUtil.getDescribedResources());
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            DomainControllerRuntimeIgnoreTransformationRegistry.this.addKnownDataForSlave(hostName, readUtil.getNewKnownRootResources());
                        }
                    }
                });
            }
        }, OperationContext.Stage.DOMAIN);
        return operation;
    }

    public void updateKnownResources(OperationContext context) {
        NewSlaveInformation info = this.getAttachment(context, false);
        if (info == null) {
            return;
        }
        for (Map.Entry entry : info.missingResources.entrySet()) {
            ((ConcurrentSet)this.hostKnownAddresses.get(entry.getKey())).addAll((Collection)entry.getValue());
        }
    }

    public void changeServerGroupProfile(OperationContext context, PathAddress serverGroupAddress, String newProfile) {
        if (this.hostEntries.size() > 0) {
            Resource domainResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            for (Map.Entry entry : this.hostEntries.entrySet()) {
                if (((DomainControllerRuntimeIgnoreTransformationEntry)entry.getValue()).ignoreResource(domainResource, serverGroupAddress)) continue;
                PathElement profileAddress = PathElement.pathElement((String)"profile", (String)newProfile);
                if (((ConcurrentSet)this.hostKnownAddresses.get(entry.getKey())).contains((Object)profileAddress)) continue;
                NewSlaveInformation newSlaveInformation = this.getAttachment(context, true);
                newSlaveInformation.addMissingResource((String)entry.getKey(), profileAddress);
            }
        }
    }

    public void changeServerGroupSocketBindingGroup(OperationContext context, PathAddress serverGroupAddress, String newSocketBindingGroup) {
        if (this.hostEntries.size() > 0) {
            Resource domainResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            for (Map.Entry entry : this.hostEntries.entrySet()) {
                if (((DomainControllerRuntimeIgnoreTransformationEntry)entry.getValue()).ignoreResource(domainResource, serverGroupAddress)) continue;
                PathElement socketBindingGroupAddress = PathElement.pathElement((String)"socket-binding-group", (String)newSocketBindingGroup);
                if (((ConcurrentSet)this.hostKnownAddresses.get(entry.getKey())).contains((Object)socketBindingGroupAddress)) continue;
                NewSlaveInformation newSlaveInformation = this.getAttachment(context, true);
                newSlaveInformation.addMissingResource((String)entry.getKey(), socketBindingGroupAddress);
            }
        }
    }

    public boolean isServerGroupKnown(Resource domainRoot, String hostName, String serverGroupName) {
        DomainControllerRuntimeIgnoreTransformationEntry hostIgnore = (DomainControllerRuntimeIgnoreTransformationEntry)this.hostEntries.get(hostName);
        return !hostIgnore.ignoreResource(domainRoot, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"server-group", (String)serverGroupName)}));
    }

    public boolean isSocketBindingGroupKnown(Resource domainRoot, String hostName, String socketBindingGroup) {
        DomainControllerRuntimeIgnoreTransformationEntry hostIgnore = (DomainControllerRuntimeIgnoreTransformationEntry)this.hostEntries.get(hostName);
        return !hostIgnore.ignoreResource(domainRoot, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)socketBindingGroup)}));
    }

    public boolean isProfileKnown(Resource domainRoot, String hostName, String profile) {
        DomainControllerRuntimeIgnoreTransformationEntry hostIgnore = (DomainControllerRuntimeIgnoreTransformationEntry)this.hostEntries.get(hostName);
        return !hostIgnore.ignoreResource(domainRoot, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile", (String)profile)}));
    }

    public Set<PathElement> getUnknownExtensionsForProfile(Resource domainRoot, String hostName, String profile) {
        DomainControllerRuntimeIgnoreTransformationEntry hostIgnore = (DomainControllerRuntimeIgnoreTransformationEntry)this.hostEntries.get(hostName);
        return hostIgnore.getUnknownExtensionsForProfile(domainRoot, PathElement.pathElement((String)"profile", (String)profile));
    }

    public void updateSlaveServerConfig(String hostName, IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo serverInfo) {
        DomainControllerRuntimeIgnoreTransformationEntry hostIgnore = (DomainControllerRuntimeIgnoreTransformationEntry)this.hostEntries.get(hostName);
        hostIgnore.updateSlaveServerConfig(serverInfo);
    }

    private NewSlaveInformation getAttachment(OperationContext context, boolean create) {
        NewSlaveInformation old;
        NewSlaveInformation info = (NewSlaveInformation)context.getAttachment(NEW_SLAVE_INFO);
        if (info == null && create && (old = (NewSlaveInformation)context.attachIfAbsent(NEW_SLAVE_INFO, (Object)(info = new NewSlaveInformation()))) != null) {
            return old;
        }
        return info;
    }

    private class NewSlaveInformation {
        private final Map<String, Set<PathElement>> missingResources = Collections.synchronizedMap(new HashMap());

        private NewSlaveInformation() {
        }

        void addMissingResource(String host, PathElement address) {
            Set<Object> hostMissingResources = this.missingResources.get(host);
            if (hostMissingResources == null) {
                hostMissingResources = Collections.synchronizedSet(new HashSet());
                this.missingResources.put(host, hostMissingResources);
            }
            hostMissingResources.add(address);
        }
    }
}

