/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import jakarta.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBean;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class StatefulComponentInstanceInterceptor
extends AbstractEJBInterceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new StatefulComponentInstanceInterceptor());
    private static final Object STATEFUL_BEAN_KEY = StatefulSessionBean.class;

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionBean<SessionID, StatefulSessionComponentInstance> bean;
        StatefulSessionComponent component = StatefulComponentInstanceInterceptor.getComponent(context, StatefulSessionComponent.class);
        SessionID sessionId = (SessionID)context.getPrivateData(SessionID.class);
        if (sessionId == null) {
            throw EjbLogger.ROOT_LOGGER.statefulSessionIdIsNull(component.getComponentName());
        }
        TransactionSynchronizationRegistry tsr = component.getTransactionSynchronizationRegistry();
        StatefulSessionBean<SessionID, StatefulSessionComponentInstance> statefulSessionBean = bean = tsr.getTransactionKey() != null ? (StatefulSessionBean<SessionID, StatefulSessionComponentInstance>)tsr.getResource((Object)sessionId) : null;
        if (bean == null) {
            EjbLogger.ROOT_LOGGER.debugf("Looking for stateful component instance with session id: %s", sessionId);
            bean = component.getCache().findStatefulSessionBean(sessionId);
        }
        if (bean == null) {
            throw EjbLogger.ROOT_LOGGER.couldNotFindEjb(sessionId.toString());
        }
        try {
            context.putPrivateData(StatefulSessionBean.class, (Object)bean);
            context.putPrivateData(ComponentInstance.class, (Object)((ComponentInstance)bean.getInstance()));
            return context.proceed();
        }
        catch (Exception ex) {
            if (component.shouldDiscard(ex, context.getMethod())) {
                EjbLogger.ROOT_LOGGER.tracef(ex, "Removing bean %s because of exception", sessionId);
                bean.discard();
            }
            throw ex;
        }
        catch (Error e) {
            EjbLogger.ROOT_LOGGER.tracef(e, "Removing bean %s because of error", sessionId);
            bean.discard();
            throw e;
        }
        catch (Throwable t) {
            EjbLogger.ROOT_LOGGER.tracef(t, "Removing bean %s because of Throwable", sessionId);
            bean.discard();
            throw new RuntimeException(t);
        }
    }

    static StatefulSessionBean<SessionID, StatefulSessionComponentInstance> getBean(InterceptorContext context) {
        return (StatefulSessionBean)context.getPrivateData(STATEFUL_BEAN_KEY);
    }
}

