/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import jakarta.ejb.EJBException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerHandle;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimer;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;

public class OOBTimer<I>
implements ManagedTimer {
    private static final ExceptionFunction<ManagedTimer, TimerHandle, EJBException> GET_HANDLE = Timer::getHandle;
    private static final ExceptionFunction<ManagedTimer, Serializable, EJBException> GET_INFO = Timer::getInfo;
    private static final ExceptionFunction<ManagedTimer, Date, EJBException> GET_NEXT_TIMEOUT = Timer::getNextTimeout;
    private static final ExceptionFunction<ManagedTimer, ScheduleExpression, EJBException> GET_SCHEDULE = Timer::getSchedule;
    private static final ExceptionFunction<ManagedTimer, Long, EJBException> GET_TIME_REMAINING = Timer::getTimeRemaining;
    private static final ExceptionFunction<ManagedTimer, Boolean, EJBException> IS_ACTIVE = ManagedTimer::isActive;
    private static final ExceptionFunction<ManagedTimer, Boolean, EJBException> IS_CALENDAR = Timer::isCalendarTimer;
    private static final ExceptionFunction<ManagedTimer, Boolean, EJBException> IS_CANCELED = ManagedTimer::isCanceled;
    private static final ExceptionFunction<ManagedTimer, Boolean, EJBException> IS_EXPIRED = ManagedTimer::isExpired;
    private static final ExceptionFunction<ManagedTimer, Boolean, EJBException> IS_PERSISTENT = Timer::isPersistent;
    private static final ExceptionConsumer<ManagedTimer, EJBException> ACTIVATE = ManagedTimer::activate;
    private static final ExceptionConsumer<ManagedTimer, EJBException> CANCEL = Timer::cancel;
    private static final ExceptionConsumer<ManagedTimer, Exception> INVOKE = ManagedTimer::invoke;
    private static final ExceptionConsumer<ManagedTimer, EJBException> SUSPEND = ManagedTimer::suspend;
    private final TimerManager<I> manager;
    private final I id;
    private final TimedObjectInvoker invoker;
    private final TimerSynchronizationFactory<I> synchronizationFactory;
    private final Function<I, org.wildfly.clustering.ejb.timer.Timer<I>> fixedReader;
    private final Function<I, org.wildfly.clustering.ejb.timer.Timer<I>> dynamicReader;
    private final Supplier<Context<Batch>> batchContextFactory;

    public OOBTimer(TimerManager<I> manager, I id, TimedObjectInvoker invoker, TimerSynchronizationFactory<I> synchronizationFactory) {
        this.manager = manager;
        this.id = id;
        this.invoker = invoker;
        this.synchronizationFactory = synchronizationFactory;
        this.fixedReader = arg_0 -> manager.readTimer(arg_0);
        this.dynamicReader = arg_0 -> manager.getTimer(arg_0);
        this.batchContextFactory = this.manager.getBatchFactory().map(batch -> Context.of((Object)batch, (java.util.function.Consumer)new Consumer<Batch>(){

            public void accept(Batch batch) {
                if (!batch.getStatus().isClosed()) {
                    batch.close();
                }
            }
        }));
    }

    public void cancel() {
        this.invoke(CANCEL);
    }

    public long getTimeRemaining() {
        return this.invokeDynamic(GET_TIME_REMAINING);
    }

    public Date getNextTimeout() {
        return this.invokeDynamic(GET_NEXT_TIMEOUT);
    }

    public ScheduleExpression getSchedule() {
        return this.invokeFixed(GET_SCHEDULE);
    }

    public boolean isPersistent() {
        return this.invokeFixed(IS_PERSISTENT);
    }

    public boolean isCalendarTimer() {
        return this.invokeFixed(IS_CALENDAR);
    }

    public Serializable getInfo() {
        return this.invokeFixed(GET_INFO);
    }

    public TimerHandle getHandle() {
        return this.invokeFixed(GET_HANDLE);
    }

    @Override
    public String getId() {
        return this.id.toString();
    }

    @Override
    public void activate() {
        this.invoke(ACTIVATE);
    }

    @Override
    public void suspend() {
        this.invoke(SUSPEND);
    }

    @Override
    public void invoke() throws Exception {
        this.invoke(INVOKE);
    }

    @Override
    public boolean isActive() {
        return this.invokeDynamic(IS_ACTIVE);
    }

    @Override
    public boolean isCanceled() {
        return this.invokeDynamic(IS_CANCELED);
    }

    @Override
    public boolean isExpired() {
        return this.invokeDynamic(IS_EXPIRED);
    }

    private <R, E extends Exception> R invokeFixed(ExceptionFunction<ManagedTimer, R, E> function) throws E {
        return this.invoke(function, this.fixedReader);
    }

    private <R, E extends Exception> R invokeDynamic(ExceptionFunction<ManagedTimer, R, E> function) throws E {
        return this.invoke(function, this.dynamicReader);
    }

    private <R, E extends Exception> R invoke(ExceptionFunction<ManagedTimer, R, E> function, Function<I, org.wildfly.clustering.ejb.timer.Timer<I>> reader) throws E {
        Map.Entry existing;
        ManagedTimer currentTimer;
        InterceptorContext interceptorContext = CurrentInvocationContext.get();
        ManagedTimer managedTimer = currentTimer = interceptorContext != null ? (ManagedTimer)interceptorContext.getTimer() : null;
        if (currentTimer != null && currentTimer.getId().equals(this.id.toString())) {
            return (R)function.apply((Object)currentTimer);
        }
        Transaction transaction = ManagedTimerService.getActiveTransaction();
        Map.Entry entry = existing = transaction != null ? (Map.Entry)this.invoker.getComponent().getTransactionSynchronizationRegistry().getResource(this.id) : null;
        if (existing != null) {
            org.wildfly.clustering.ejb.timer.Timer timer = (org.wildfly.clustering.ejb.timer.Timer)existing.getKey();
            SuspendedBatch suspendedBatch = (SuspendedBatch)existing.getValue();
            return (R)function.apply(new DistributableTimer<I>(this.manager, timer, suspendedBatch, this.invoker, this.synchronizationFactory));
        }
        try (Context batch = (Context)this.batchContextFactory.get();){
            Object object;
            block15: {
                org.wildfly.clustering.ejb.timer.Timer<I> timer = reader.apply(this.id);
                if (timer == null) {
                    throw EjbLogger.ROOT_LOGGER.timerWasCanceled(this.id.toString());
                }
                Context context = ((Batch)batch.get()).suspendWithContext();
                try {
                    object = function.apply(new DistributableTimer<I>(this.manager, timer, (SuspendedBatch)context.get(), this.invoker, this.synchronizationFactory));
                    if (context == null) break block15;
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                context.close();
            }
            return (R)object;
        }
    }

    private <E extends Exception> void invoke(final ExceptionConsumer<ManagedTimer, E> consumer) throws E {
        this.invoke(new ExceptionFunction<ManagedTimer, Void, E>(){

            public Void apply(ManagedTimer timer) throws Exception {
                consumer.accept((Object)timer);
                return null;
            }
        }, this.dynamicReader);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManagedTimer)) {
            return false;
        }
        return this.getId().equals(((ManagedTimer)object).getId());
    }

    public String toString() {
        return this.getId();
    }
}

