/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import jakarta.ejb.TimerConfig;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.timerservice.SuspendableTimerService;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimeoutListener;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerService;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactoryConfiguration;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvokerFactory;
import org.jboss.as.ejb3.timerservice.spi.TimerListener;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.timer.TimeoutListener;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManagementProvider;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerManagerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerManagerFactory;
import org.wildfly.clustering.ejb.timer.TimerManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.ejb.timer.TimerServiceConfiguration;
import org.wildfly.clustering.server.util.UUIDFactory;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class DistributableTimerServiceFactoryServiceInstaller
implements ServiceInstaller {
    private final ServiceName name;
    private final ManagedTimerServiceFactoryConfiguration factoryConfiguration;
    private final TimerServiceConfiguration configuration;
    private final Supplier<TimerManagementProvider> provider;
    private final Predicate<TimerConfig> filter;

    public DistributableTimerServiceFactoryServiceInstaller(ServiceName name, ManagedTimerServiceFactoryConfiguration factoryConfiguration, TimerServiceConfiguration configuration, Supplier<TimerManagementProvider> provider, Predicate<TimerConfig> filter) {
        this.name = name;
        this.factoryConfiguration = factoryConfiguration;
        this.configuration = configuration;
        this.provider = provider;
        this.filter = filter;
    }

    public ServiceController<?> install(RequirementServiceTarget target) {
        TimerServiceRegistry registry = this.factoryConfiguration.getTimerServiceRegistry();
        final TimedObjectInvokerFactory invokerFactory = this.factoryConfiguration.getInvokerFactory();
        final TimerListener listener = this.factoryConfiguration.getTimerListener();
        Predicate<TimerConfig> filter = this.filter;
        final TimerServiceConfiguration configuration = this.configuration;
        final boolean persistent = filter.test(new TimerConfig(null, true));
        TimerIdentifierFactory identifierFactory = TimerIdentifierFactory.INSTANCE;
        TimerRegistry<UUID> timerRegistry = new TimerRegistry<UUID>(){

            public void register(UUID id) {
                listener.timerAdded(id.toString());
            }

            public void unregister(UUID id) {
                listener.timerRemoved(id.toString());
            }
        };
        TimerManagerFactoryConfiguration<UUID> managerFactoryConfiguration = new TimerManagerFactoryConfiguration<UUID>((TimerRegistry)timerRegistry, (org.wildfly.clustering.function.Supplier)identifierFactory){
            final /* synthetic */ TimerRegistry val$timerRegistry;
            final /* synthetic */ org.wildfly.clustering.function.Supplier val$identifierFactory;
            {
                this.val$timerRegistry = timerRegistry;
                this.val$identifierFactory = supplier;
            }

            public boolean isPersistent() {
                return persistent;
            }

            public TimerServiceConfiguration getTimerServiceConfiguration() {
                return configuration;
            }

            public TimerRegistry<UUID> getRegistry() {
                return this.val$timerRegistry;
            }

            public org.wildfly.clustering.function.Supplier<UUID> getIdentifierFactory() {
                return this.val$identifierFactory;
            }
        };
        ServiceName timerManagerFactoryName = ServiceName.JBOSS.append(new String[]{"clustering", "timer", this.configuration.getName()});
        for (ServiceInstaller installer : this.provider.get().getTimerManagerFactoryServiceInstallers(timerManagerFactoryName, (TimerManagerFactoryConfiguration)managerFactoryConfiguration)) {
            installer.install((ServiceTarget)target);
        }
        ServiceDependency managerFactory = ServiceDependency.on((ServiceName)timerManagerFactoryName);
        ServiceDependency activityRegistry = ServiceDependency.on((NullaryServiceDescriptor)SuspendableActivityRegistry.SERVICE_DESCRIPTOR);
        ManagedTimerServiceFactory factory = new ManagedTimerServiceFactory(){
            final /* synthetic */ TimerRegistry val$timerRegistry;
            final /* synthetic */ ServiceDependency val$managerFactory;
            final /* synthetic */ TimerServiceConfiguration val$configuration;
            final /* synthetic */ org.wildfly.clustering.function.Supplier val$identifierFactory;
            final /* synthetic */ boolean val$persistent;
            final /* synthetic */ TimerServiceRegistry val$registry;
            final /* synthetic */ TimerListener val$listener;
            final /* synthetic */ Predicate val$filter;
            final /* synthetic */ ServiceDependency val$activityRegistry;
            {
                this.val$timerRegistry = timerRegistry;
                this.val$managerFactory = serviceDependency;
                this.val$configuration = timerServiceConfiguration;
                this.val$identifierFactory = supplier;
                this.val$persistent = bl;
                this.val$registry = timerServiceRegistry;
                this.val$listener = timerListener;
                this.val$filter = predicate;
                this.val$activityRegistry = serviceDependency2;
            }

            @Override
            public ManagedTimerService createTimerService(EJBComponent component) {
                final TimedObjectInvoker invoker = invokerFactory.createInvoker(component);
                Consumer<Timer<UUID>> activateTask = new Consumer<Timer<UUID>>(){

                    @Override
                    public void accept(Timer<UUID> timer) {
                        timer.activate();
                        val$timerRegistry.register((Object)((UUID)timer.getId()));
                    }
                };
                Consumer<Timer<UUID>> cancelTask = new Consumer<Timer<UUID>>(){

                    @Override
                    public void accept(Timer<UUID> timer) {
                        val$timerRegistry.unregister((Object)((UUID)timer.getId()));
                        timer.cancel();
                    }
                };
                final DistributableTimerSynchronizationFactory<UUID> synchronizationFactory = new DistributableTimerSynchronizationFactory<UUID>(activateTask, cancelTask);
                final DistributableTimeoutListener<UUID> timeoutListener = new DistributableTimeoutListener<UUID>(invoker, synchronizationFactory);
                TimerManager manager = ((TimerManagerFactory)this.val$managerFactory.get()).createTimerManager((TimerManagerConfiguration)new TimerManagerConfiguration<UUID>(){

                    public TimerServiceConfiguration getTimerServiceConfiguration() {
                        return val$configuration;
                    }

                    public org.wildfly.clustering.function.Supplier<UUID> getIdentifierFactory() {
                        return val$identifierFactory;
                    }

                    public TimerRegistry<UUID> getRegistry() {
                        return val$timerRegistry;
                    }

                    public boolean isPersistent() {
                        return val$persistent;
                    }

                    public TimeoutListener<UUID> getListener() {
                        return timeoutListener;
                    }
                });
                DistributableTimerServiceConfiguration<UUID> serviceConfiguration = new DistributableTimerServiceConfiguration<UUID>(){

                    @Override
                    public TimedObjectInvoker getInvoker() {
                        return invoker;
                    }

                    @Override
                    public TimerServiceRegistry getTimerServiceRegistry() {
                        return val$registry;
                    }

                    @Override
                    public TimerListener getTimerListener() {
                        return val$listener;
                    }

                    @Override
                    public Function<String, UUID> getIdentifierParser() {
                        return TimerIdentifierFactory.INSTANCE;
                    }

                    @Override
                    public Predicate<TimerConfig> getTimerFilter() {
                        return val$filter;
                    }

                    @Override
                    public TimerSynchronizationFactory<UUID> getTimerSynchronizationFactory() {
                        return synchronizationFactory;
                    }
                };
                return new SuspendableTimerService(new DistributableTimerService<UUID>(serviceConfiguration, manager), (SuspendableActivityRegistry)this.val$activityRegistry.get());
            }
        };
        return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)Functions.constantSupplier((Object)factory)).provides(this.name)).requires(List.of(managerFactory, activityRegistry))).build()).install((ServiceTarget)target);
    }

    static enum TimerIdentifierFactory implements org.wildfly.clustering.function.Supplier<UUID>,
    Function<String, UUID>
    {
        INSTANCE;


        public UUID get() {
            return (UUID)UUIDFactory.INSECURE.get();
        }

        @Override
        public UUID apply(String id) {
            return UUID.fromString(id);
        }
    }
}

