/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import jakarta.ejb.EJBException;
import jakarta.ejb.NoMoreTimeoutsException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.TimerHandle;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerHandleImpl;
import org.jboss.as.ejb3.timerservice.distributable.OOBTimer;
import org.jboss.as.ejb3.timerservice.distributable.SimpleImmutableScheduleExpression;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;

public class DistributableTimer<I>
implements ManagedTimer {
    private final TimerManager<I> manager;
    private final Timer<I> timer;
    private final SuspendedBatch suspendedBatch;
    private final TimedObjectInvoker invoker;
    private final TimerSynchronizationFactory<I> synchronizationFactory;

    public DistributableTimer(TimerManager<I> manager, Timer<I> timer, SuspendedBatch suspendedBatch, TimedObjectInvoker invoker, TimerSynchronizationFactory<I> synchronizationFactory) {
        this.manager = manager;
        this.timer = timer;
        this.suspendedBatch = suspendedBatch;
        this.invoker = invoker;
        this.synchronizationFactory = synchronizationFactory;
    }

    @Override
    public String getId() {
        return this.timer.getId().toString();
    }

    @Override
    public boolean isActive() {
        return this.timer.isActive() && !this.timer.isCanceled();
    }

    @Override
    public boolean isCanceled() {
        return this.timer.isCanceled();
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public void activate() {
        this.timer.activate();
    }

    @Override
    public void suspend() {
        this.timer.suspend();
    }

    @Override
    public void invoke() throws Exception {
        Predicate matcher = this.timer.getMetaData().getTimeoutMatcher();
        EJBComponent component = this.invoker.getComponent();
        EJBComponentDescription description = component.getComponentDescription();
        Method method = description.getScheduleMethods().keySet().stream().filter(matcher).findFirst().orElse(component.getTimeoutMethod());
        this.invoker.callTimeout(this, method);
    }

    public void cancel() {
        block11: {
            this.validateInvocationContext();
            Transaction transaction = ManagedTimerService.getActiveTransaction();
            try (BatchContext context = this.suspendedBatch.resumeWithContext();){
                if (transaction != null) {
                    this.timer.suspend();
                    try {
                        transaction.registerSynchronization(this.synchronizationFactory.createCancelSynchronization(this.timer, this.manager.getBatchFactory(), this.suspendedBatch));
                    }
                    catch (RollbackException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (SystemException e) {
                        ((Batch)context.get()).discard();
                        throw new EJBException((Exception)((Object)e));
                    }
                    Set inactiveTimers = (Set)this.invoker.getComponent().getTransactionSynchronizationRegistry().getResource(this.manager);
                    if (inactiveTimers != null) {
                        inactiveTimers.remove(this.timer.getId());
                    }
                    break block11;
                }
                this.synchronizationFactory.getCancelTask().accept(this.timer);
            }
        }
    }

    public long getTimeRemaining() {
        this.validateInvocationContext();
        try (BatchContext context = this.suspendedBatch.resumeWithContext();){
            Instant next = (Instant)this.timer.getMetaData().getNextTimeout().orElseThrow(NoMoreTimeoutsException::new);
            long l = Duration.between(Instant.now(), next).toMillis();
            return l;
        }
    }

    public Date getNextTimeout() {
        this.validateInvocationContext();
        try (BatchContext context = this.suspendedBatch.resumeWithContext();){
            Instant next = (Instant)this.timer.getMetaData().getNextTimeout().orElseThrow(NoMoreTimeoutsException::new);
            Date date = Date.from(next);
            return date;
        }
    }

    public Serializable getInfo() {
        this.validateInvocationContext();
        try (BatchContext context = this.suspendedBatch.resumeWithContext();){
            Serializable serializable = (Serializable)this.timer.getMetaData().getContext();
            return serializable;
        }
    }

    public TimerHandle getHandle() {
        this.validateInvocationContext();
        if (!this.timer.getMetaData().isPersistent()) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerHandlersForPersistentTimers("EJB3.1 Spec 18.2.6");
        }
        return new TimerHandleImpl(new OOBTimer<Object>(this.manager, this.timer.getId(), this.invoker, this.synchronizationFactory), this.invoker.getComponent());
    }

    public ScheduleExpression getSchedule() {
        this.validateInvocationContext();
        if (!this.timer.getMetaData().getType().isCalendar()) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerNotCalendarBaseTimer(this);
        }
        try (BatchContext context = this.suspendedBatch.resumeWithContext();){
            ZoneId zone;
            Instant end;
            ImmutableScheduleExpression expression = ((ScheduleTimerConfiguration)this.timer.getMetaData().getConfiguration(ScheduleTimerConfiguration.class)).getScheduleExpression();
            ScheduleExpression result = new ScheduleExpression().second(expression.getSecond()).minute(expression.getMinute()).hour(expression.getHour()).dayOfMonth(expression.getDayOfMonth()).month(expression.getMonth()).dayOfWeek(expression.getDayOfWeek()).year(expression.getYear());
            Instant start = expression.getStart();
            if (start != null) {
                result.start(Date.from(start));
            }
            if ((end = expression.getEnd()) != null) {
                result.end(Date.from(end));
            }
            if ((zone = expression.getZone()) != SimpleImmutableScheduleExpression.DEFAULT_ZONE_ID) {
                result.timezone(zone.getId());
            }
            ScheduleExpression scheduleExpression = result;
            return scheduleExpression;
        }
    }

    public boolean isCalendarTimer() {
        this.validateInvocationContext();
        try (BatchContext context = this.suspendedBatch.resumeWithContext();){
            boolean bl = this.timer.getMetaData().getType().isCalendar();
            return bl;
        }
    }

    public boolean isPersistent() {
        this.validateInvocationContext();
        try (BatchContext context = this.suspendedBatch.resumeWithContext();){
            boolean bl = this.timer.getMetaData().isPersistent();
            return bl;
        }
    }

    public int hashCode() {
        return this.timer.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManagedTimer)) {
            return false;
        }
        return this.getId().equals(((ManagedTimer)object).getId());
    }

    public String toString() {
        return this.getId();
    }
}

