/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.component.deployers.DefaultBindingsConfigurationProcessor;
import org.jboss.as.ee.subsystem.DefaultBindingsResourceDefinition;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;

public class DefaultBindingsAdd
extends AbstractBoottimeAddStepHandler {
    private final DefaultBindingsConfigurationProcessor defaultBindingsConfigurationProcessor;

    public DefaultBindingsAdd(DefaultBindingsConfigurationProcessor defaultBindingsConfigurationProcessor) {
        super((AttributeDefinition[])DefaultBindingsResourceDefinition.ATTRIBUTES);
        this.defaultBindingsConfigurationProcessor = defaultBindingsConfigurationProcessor;
    }

    protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        if (model.hasDefined("context-service")) {
            String contextService = DefaultBindingsResourceDefinition.CONTEXT_SERVICE_AD.resolveModelAttribute(context, model).asString();
            this.defaultBindingsConfigurationProcessor.setContextService(contextService);
        }
        if (model.hasDefined("datasource")) {
            String dataSource = DefaultBindingsResourceDefinition.DATASOURCE_AD.resolveModelAttribute(context, model).asString();
            this.defaultBindingsConfigurationProcessor.setDataSource(dataSource);
        }
        if (model.hasDefined("jms-connection-factory")) {
            String jmsConnectionFactory = DefaultBindingsResourceDefinition.JMS_CONNECTION_FACTORY_AD.resolveModelAttribute(context, model).asString();
            this.defaultBindingsConfigurationProcessor.setJmsConnectionFactory(jmsConnectionFactory);
        }
        if (model.hasDefined("managed-executor-service")) {
            String managedExecutorService = DefaultBindingsResourceDefinition.MANAGED_EXECUTOR_SERVICE_AD.resolveModelAttribute(context, model).asString();
            this.defaultBindingsConfigurationProcessor.setManagedExecutorService(managedExecutorService);
        }
        if (model.hasDefined("managed-scheduled-executor-service")) {
            String managedScheduledExecutorService = DefaultBindingsResourceDefinition.MANAGED_SCHEDULED_EXECUTOR_SERVICE_AD.resolveModelAttribute(context, model).asString();
            this.defaultBindingsConfigurationProcessor.setManagedScheduledExecutorService(managedScheduledExecutorService);
        }
        if (model.hasDefined("managed-thread-factory")) {
            String managedThreadFactory = DefaultBindingsResourceDefinition.MANAGED_THREAD_FACTORY_AD.resolveModelAttribute(context, model).asString();
            this.defaultBindingsConfigurationProcessor.setManagedThreadFactory(managedThreadFactory);
        }
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("ee", Phase.STRUCTURE, 6928, (DeploymentUnitProcessor)DefaultBindingsAdd.this.defaultBindingsConfigurationProcessor);
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

