/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.DomainApiHandler;
import org.jboss.as.domain.http.server.DomainApiUploadHandler;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.security.SubjectDoAsHandler;

class DomainApiCheckHandler
implements HttpHandler {
    static String PATH = "/management";
    private static final String UPLOAD_REQUEST = PATH + "/add-content";
    private final ControlledProcessStateService controlledProcessStateService;
    private final HttpHandler domainApiHandler;
    private final HttpHandler uploadHandler;

    DomainApiCheckHandler(ModelController modelController, ControlledProcessStateService controlledProcessStateService) {
        this.controlledProcessStateService = controlledProcessStateService;
        this.domainApiHandler = new BlockingHandler((HttpHandler)new SubjectDoAsHandler(new DomainApiHandler(modelController)));
        this.uploadHandler = new BlockingHandler((HttpHandler)new SubjectDoAsHandler(new DomainApiUploadHandler(modelController)));
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (!this.commonChecks(exchange)) {
            return;
        }
        boolean isUpload = UPLOAD_REQUEST.equals(exchange.getRequestPath());
        if (Methods.POST.equals(exchange.getRequestMethod())) {
            if (isUpload) {
                this.uploadHandler.handleRequest(exchange);
                return;
            }
            if (!this.checkPostContentType(exchange)) {
                return;
            }
        }
        this.domainApiHandler.handleRequest(exchange);
    }

    private boolean checkPostContentType(HttpServerExchange exchange) throws Exception {
        HeaderMap headers = exchange.getRequestHeaders();
        String contentType = this.extractContentType(headers.getFirst(Headers.CONTENT_TYPE));
        if (!"application/json".equals(contentType) && !"application/dmr-encoded".equals(contentType)) {
            HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to unsupported media type - should be one of (application/json,application/dmr-encoded).");
            Common.UNSUPPORTED_MEDIA_TYPE.handleRequest(exchange);
            return false;
        }
        return true;
    }

    private String extractContentType(String fullContentType) {
        int pos = fullContentType.indexOf(59);
        return pos < 0 ? fullContentType : fullContentType.substring(0, pos).trim();
    }

    private boolean commonChecks(HttpServerExchange exchange) throws Exception {
        if (exchange.getQueryParameters().containsKey("org.jboss.as.console.logout.context")) {
            this.contextLogout(exchange);
            return false;
        }
        ControlledProcessState.State currentState = this.controlledProcessStateService.getCurrentState();
        if (currentState == ControlledProcessState.State.STARTING || currentState == ControlledProcessState.State.STOPPING) {
            exchange.getResponseHeaders().add(Headers.RETRY_AFTER, "2");
            Common.SERVICE_UNAVAIABLE.handleRequest(exchange);
            return false;
        }
        HttpString requestMethod = exchange.getRequestMethod();
        if (!Methods.POST.equals(requestMethod) && !Methods.GET.equals(requestMethod)) {
            if (Methods.OPTIONS.equals(requestMethod)) {
                HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to 'OPTIONS' method which is not supported.");
            } else {
                HttpServerLogger.ROOT_LOGGER.debug("Request rejected as method not one of (GET,POST).");
            }
            Common.METHOD_NOT_ALLOWED_HANDLER.handleRequest(exchange);
            return false;
        }
        HeaderMap headers = exchange.getRequestHeaders();
        if (headers.contains(Headers.ORIGIN)) {
            String origin = headers.getFirst(Headers.ORIGIN);
            String host = headers.getFirst(Headers.HOST);
            String protocol = exchange.getRequestScheme();
            String allowedOrigin = protocol + "://" + host;
            if (!origin.equals(allowedOrigin)) {
                HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to HOST/ORIGIN mis-match.");
                ResponseCodeHandler.HANDLE_403.handleRequest(exchange);
                return false;
            }
        }
        return true;
    }

    private void contextLogout(HttpServerExchange exchange) {
        SecurityContext context = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        context.logout();
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        String host = null;
        String protocol = "http";
        String referrer = responseHeaders.getFirst(Headers.REFERER);
        if (referrer != null) {
            try {
                URI uri = new URI(referrer);
                protocol = uri.getScheme();
                host = uri.getHost() + (uri.getPort() == -1 ? "" : ":" + String.valueOf(uri.getPort()));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (host == null && (host = requestHeaders.getFirst(Headers.HOST)) == null) {
            exchange.setResponseCode(500);
            return;
        }
        responseHeaders.add(Headers.LOCATION, protocol + "://" + host + "/logout?" + "org.jboss.as.console.logout.redirect");
        exchange.setResponseCode(307);
    }
}

