/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.ResourceHandlerDefinition;

class ManagementRootConsoleRedirectHandler
implements HttpHandler {
    private static HttpString HTTP_GET = new HttpString("GET");
    private final ResourceHandlerDefinition consoleHandler;

    ManagementRootConsoleRedirectHandler(ResourceHandlerDefinition consoleHandler) {
        this.consoleHandler = consoleHandler;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (!exchange.getRequestMethod().equals(HTTP_GET)) {
            Common.METHOD_NOT_ALLOWED_HANDLER.handleRequest(exchange);
            return;
        }
        String requestUrl = exchange.getRequestURL();
        if (this.consoleHandler != null && "/".equals(exchange.getRequestPath())) {
            StringBuilder redirect = new StringBuilder(requestUrl);
            redirect.append(this.consoleHandler.getContext()).append(this.consoleHandler.getDefaultPath());
            exchange.getResponseHeaders().add(Headers.LOCATION, redirect.toString());
            Common.MOVED_PERMANENTLY.handleRequest(exchange);
            return;
        }
        Common.NOT_FOUND.handleRequest(exchange);
    }
}

