/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class SocketBindingAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    public static final SocketBindingAddHandler INSTANCE = new SocketBindingAddHandler();

    public static ModelNode getOperation(PathAddress address, ModelNode socketBinding) {
        ModelNode op = Util.createAddOperation((PathAddress)address);
        if (socketBinding.get("interface").isDefined()) {
            op.get("interface").set(socketBinding.get("interface"));
        }
        if (socketBinding.hasDefined("port")) {
            op.get("port").set(socketBinding.get("port"));
        }
        if (socketBinding.hasDefined("fixed-port")) {
            op.get("fixed-port").set(socketBinding.get("fixed-port"));
        }
        if (socketBinding.hasDefined("multicast-address")) {
            op.get("multicast-address").set(socketBinding.get("multicast-address"));
        }
        if (socketBinding.hasDefined("multicast-port")) {
            op.get("multicast-port").set(socketBinding.get("multicast-port"));
        }
        if (socketBinding.hasDefined("client-mappings")) {
            op.get("client-mappings").set(socketBinding.get("client-mappings"));
        }
        return op;
    }

    protected SocketBindingAddHandler() {
    }

    protected void populateModel(final OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        model.get("name").set(context.getCurrentAddressValue());
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final String socketBindingGroupName = address.getParent().getLastElement().getValue();
        final String socketBindingName = address.getLastElement().getValue();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context2, ModelNode operation) throws OperationFailedException {
                if (!context2.getProcessType().isServer()) {
                    try {
                        Resource resource = context2.readResourceFromRoot(context2.getCurrentAddress().getParent(), false);
                        this.validation(socketBindingGroupName, socketBindingName, resource, true, new ArrayList<String>());
                    }
                    catch (Resource.NoSuchResourceException e) {
                        return;
                    }
                } else {
                    Resource resource = context2.readResourceFromRoot(PathAddress.pathAddress((String)"socket-binding-group", (String)socketBindingGroupName), false);
                    this.validation(socketBindingGroupName, socketBindingName, resource, false, new ArrayList<String>());
                }
            }

            private void validation(String socketBindingGroupName2, String socketBindingName2, Resource resource, boolean recursive, List<String> validatedGroupList) {
                Set localDestinationOutboundSocketBindingNames = resource.getChildrenNames("local-destination-outbound-socket-binding");
                Set remoteDestinationOutboundSocketBindingNames = resource.getChildrenNames("remote-destination-outbound-socket-binding");
                if (localDestinationOutboundSocketBindingNames.contains(socketBindingName2) || remoteDestinationOutboundSocketBindingNames.contains(socketBindingName2)) {
                    throw ControllerLogger.ROOT_LOGGER.socketBindingalreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), socketBindingName2, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName2);
                }
                validatedGroupList.add(socketBindingName2);
                if (recursive && resource.getModel().hasDefined("includes")) {
                    List includedSocketBindingGroups = resource.getModel().get("includes").asList();
                    for (ModelNode includedSocketBindingGroup : includedSocketBindingGroups) {
                        String includedSocketBindingGroupName = includedSocketBindingGroup.asString();
                        if (validatedGroupList.contains(includedSocketBindingGroupName)) continue;
                        Resource includedResource = context.readResourceFromRoot(PathAddress.pathAddress((String)"socket-binding-group", (String)includedSocketBindingGroupName), false);
                        this.validation(includedSocketBindingGroupName, socketBindingName2, includedResource, recursive, validatedGroupList);
                    }
                }
            }
        }, OperationContext.Stage.MODEL);
        super.populateModel(context, operation, resource);
    }
}

