/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.security.sasl;

import java.util.Map;
import java.util.function.Predicate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.as.server.security.sasl.DomainServerSaslServer;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.evidence.Evidence;

public class DomainServerSaslServerFactory
implements SaslServerFactory {
    private final SecurityDomain securityDomain;
    private final Predicate<Evidence> evidenceVerifier;

    public DomainServerSaslServerFactory(SecurityDomain securityDomain, Predicate<Evidence> evidenceVerifier) {
        this.securityDomain = securityDomain;
        this.evidenceVerifier = evidenceVerifier;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return "JBOSS-DOMAIN-SERVER".equals(mechanism) ? new DomainServerSaslServer(this.securityDomain, this.evidenceVerifier, cbh) : null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{"JBOSS-DOMAIN-SERVER"};
    }
}

