/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.AbstractDeploymentUploadHandler;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadStreamAttachmentHandler
extends AbstractDeploymentUploadHandler {
    public static final String OPERATION_NAME = "upload-deployment-stream";

    private DeploymentUploadStreamAttachmentHandler(ContentRepository repository, AttributeDefinition attribute) {
        super(repository, attribute);
    }

    public static void register(ManagementResourceRegistration registration, ContentRepository repository) {
        registration.registerOperationHandler(DeploymentAttributes.UPLOAD_STREAM_ATTACHMENT_DEFINITION, (OperationStepHandler)new DeploymentUploadStreamAttachmentHandler(repository, DeploymentAttributes.INPUT_STREAM_INDEX_NOT_NULL));
    }

    @Override
    protected InputStream getContentInputStream(OperationContext operationContext, ModelNode operation) throws IOException, OperationFailedException {
        int streamIndex = operation.require("input-stream-index").asInt();
        InputStream in = operationContext.getAttachmentStream(streamIndex);
        if (in == null) {
            throw ServerLogger.ROOT_LOGGER.nullStreamAttachment(streamIndex);
        }
        return in;
    }
}

